/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.catonine.stylerule;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import nu.zoom.catonine.stylerule.ChangeTracker;
import nu.zoom.catonine.stylerule.StyleRule;
import nu.zoom.catonine.stylerule.StyleRuleListener;
import nu.zoom.catonine.stylerule.StyleRulesListener;
import nu.zoom.catonine.xml.JAXBPatternAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"name", "guid", "logBlockPattern", "logBlockPatternBeginsBlock", "fileEncoding", "patternStyles"})
public class StyleRules
implements Serializable,
ChangeTracker {
    private static final long serialVersionUID = 1L;
    private transient Log log = LogFactory.getLog(this.getClass());
    private transient boolean changed = false;
    private transient ArrayList<StyleRulesListener> listeners = new ArrayList();
    private static final Pattern defaultPattern = Pattern.compile("((\\n\\r?)|(\\r\\n?))");
    private String name;
    private String guid;
    @XmlJavaTypeAdapter(value=JAXBPatternAdapter.class)
    private Pattern logBlockPattern;
    private boolean logBlockPatternBeginsBlock;
    private String fileEncoding;
    private ArrayList<StyleRule> patternStyles = new ArrayList();

    StyleRules() {
        this.log.trace((Object)"Marshalling created a new style rule");
    }

    public StyleRules(String name) {
        this.name = name;
        this.guid = UUID.randomUUID().toString();
        this.logBlockPattern = defaultPattern;
        this.logBlockPatternBeginsBlock = false;
        this.fileEncoding = Charset.defaultCharset().name();
        this.log.trace((Object)("Created style rules named: " + name));
    }

    public synchronized List<StyleRule> getPatternStyles() {
        return new ArrayList<StyleRule>(this.patternStyles);
    }

    public synchronized void add(StyleRule style) {
        this.log.trace((Object)("Adding style rule " + style + " to style rules named: " + this.name));
        this.patternStyles.add(style);
        this.fireStructureChanged();
    }

    public synchronized void remove(StyleRule style) {
        this.log.trace((Object)("Removing style rule " + style + " from style rules named: " + this.name));
        this.patternStyles.remove(style);
        this.fireStructureChanged();
    }

    public synchronized void moveUp(StyleRule style) {
        int index = this.patternStyles.indexOf(style);
        if (index > 0) {
            this.log.trace((Object)("Moving style rule: " + style + " from index: " + index + " upwards "));
            this.patternStyles.remove(style);
            this.patternStyles.add(index - 1, style);
            this.fireStructureChanged();
        }
    }

    public synchronized void moveDown(StyleRule style) {
        int index = this.patternStyles.indexOf(style);
        if (index > -1 && index < this.patternStyles.size() - 1) {
            this.log.trace((Object)("Moving style rule: " + style + " from index: " + index + " downwards."));
            this.patternStyles.remove(style);
            this.patternStyles.add(index + 1, style);
            this.fireStructureChanged();
        }
    }

    public String getGuid() {
        return this.guid;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String newName) {
        this.log.trace((Object)("Changing style rules name from: " + this.name + " to " + newName));
        this.name = newName;
        this.fireListChangedName();
    }

    public synchronized void addListener(StyleRulesListener listener) {
        this.log.trace((Object)("Adding listener: " + listener));
        this.listeners.add(listener);
    }

    public synchronized void addStyleRuleListener(StyleRuleListener listener) {
        this.log.trace((Object)("Adding style rule listener: " + listener + " to all style rules"));
        for (StyleRule rule : this.patternStyles) {
            rule.addListener(listener);
        }
    }

    public synchronized void removeStyleRuleListener(StyleRuleListener listener) {
        this.log.trace((Object)("Removing style rule listener: " + listener + " from all style rules"));
        for (StyleRule rule : this.patternStyles) {
            rule.removeListener(listener);
        }
    }

    public synchronized void removeListener(StyleRulesListener listener) {
        this.log.trace((Object)("Removing listener: " + listener));
        this.listeners.remove(listener);
    }

    private synchronized void fireStructureChanged() {
        this.log.trace((Object)"Informing listeners that structure changed");
        this.changed = true;
        ArrayList<Thread> notifierThreads = new ArrayList<Thread>();
        if (this.listeners.size() > 0) {
            for (final StyleRulesListener listener : this.listeners) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        listener.listStructureChanged(StyleRules.this);
                    }
                });
                notifierThreads.add(t);
            }
        }
        for (Thread t : notifierThreads) {
            this.log.trace((Object)"Starting notifier thread");
            t.start();
        }
    }

    private synchronized void fireDataChanged() {
        this.log.trace((Object)"Informing listeners that structure changed");
        this.changed = true;
        ArrayList<Thread> notifierThreads = new ArrayList<Thread>();
        if (this.listeners.size() > 0) {
            for (final StyleRulesListener listener : this.listeners) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        listener.listDataChanged(StyleRules.this);
                    }
                });
                notifierThreads.add(t);
            }
        }
        for (Thread t : notifierThreads) {
            this.log.trace((Object)"Starting notifier thread");
            t.start();
        }
    }

    private synchronized void fireListChangedName() {
        this.log.trace((Object)"Informing listeners that name changed");
        this.changed = true;
        ArrayList<Thread> notifierThreads = new ArrayList<Thread>();
        if (this.listeners.size() > 0) {
            for (final StyleRulesListener listener : this.listeners) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        listener.listChangedName(StyleRules.this);
                    }
                });
                notifierThreads.add(t);
            }
        }
        for (Thread t : notifierThreads) {
            this.log.trace((Object)"Starting notifier thread");
            t.start();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof StyleRules) {
            return this.guid.equals(((StyleRules)obj).guid);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + (this.guid != null ? this.guid.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean isChanged() {
        if (!this.changed) {
            for (StyleRule rule : this.patternStyles) {
                if (!rule.isChanged()) continue;
                this.log.trace((Object)"Style rules found a rule that is changed, setting changed status for collection");
                this.changed = true;
            }
        }
        return this.changed;
    }

    @Override
    public void resetChangeStatus() {
        this.changed = false;
        this.log.trace((Object)"Resetting changed status for all rules");
        for (StyleRule rule : this.patternStyles) {
            rule.resetChangeStatus();
        }
    }

    public synchronized Pattern getLogBlockPattern() {
        return this.logBlockPattern;
    }

    public synchronized void setLogBlockPattern(Pattern linePattern) {
        if (linePattern != null && !linePattern.equals(this.logBlockPattern)) {
            this.logBlockPattern = linePattern;
            this.fireDataChanged();
        }
    }

    public synchronized boolean isLogBlockPatternBeginsBlock() {
        return this.logBlockPatternBeginsBlock;
    }

    public synchronized void setLogBlockPatternBeginsBlock(boolean logBlockPatternBeginsBlock) {
        if (this.logBlockPatternBeginsBlock != logBlockPatternBeginsBlock) {
            this.logBlockPatternBeginsBlock = logBlockPatternBeginsBlock;
            this.fireDataChanged();
        }
    }

    public synchronized String getFileEncoding() {
        return this.fileEncoding;
    }

    public synchronized void setFileEncoding(String fileEncoding) {
        if (!this.fileEncoding.equals(fileEncoding)) {
            this.fileEncoding = fileEncoding;
            this.fireDataChanged();
        }
    }
}

