/*
 * Decompiled with CFR 0.152.
 */
package nl.knaw.dans.common.dbflib;

import java.util.Date;
import nl.knaw.dans.common.dbflib.AbstractDataValidator;
import nl.knaw.dans.common.dbflib.DataMismatchException;
import nl.knaw.dans.common.dbflib.DbfLibException;
import nl.knaw.dans.common.dbflib.Field;
import nl.knaw.dans.common.dbflib.Type;
import nl.knaw.dans.common.dbflib.ValueTooLargeException;

class CharacterFormatValidator
extends AbstractDataValidator {
    public CharacterFormatValidator(Field field) {
        super(field);
        assert (field.getType() == Type.CHARACTER) : "Can only be validator for CHARACTER fields";
    }

    @Override
    public void validate(Object typedObject) throws DbfLibException {
        if (typedObject instanceof String || typedObject instanceof Number) {
            if (typedObject.toString().length() > this.field.getLength()) {
                throw new ValueTooLargeException("Value too large to it in field");
            }
            return;
        }
        if (typedObject instanceof Date) {
            if (this.field.getLength() < Type.DATE.getLength()) {
                throw new ValueTooLargeException("Field too short to contain a date");
            }
            return;
        }
        if (typedObject instanceof Boolean) {
            return;
        }
        throw new DataMismatchException("Cannot add value of type " + typedObject.getClass().getName());
    }
}

