/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.storage.message.impl;

import javax.jms.JMSException;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.management.destination.definition.QueueDefinition;
import net.timewalker.ffmq4.storage.data.LinkedDataStore;
import net.timewalker.ffmq4.storage.message.MessageStore;
import net.timewalker.ffmq4.utils.concurrent.SynchronizationBarrier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMessageStore
implements MessageStore {
    private static final Log log = LogFactory.getLog(AbstractMessageStore.class);
    protected QueueDefinition queueDef;
    protected LinkedDataStore dataStore;
    private int[] handleByPriority = new int[10];

    public AbstractMessageStore(QueueDefinition queueDef) {
        this.queueDef = queueDef;
    }

    protected abstract LinkedDataStore createDataStore();

    @Override
    public void init() throws JMSException {
        this.dataStore = this.createDataStore();
        this.dataStore.init();
        this.initPriorityTable();
    }

    private void initPriorityTable() throws JMSException {
        for (int n = 0; n < this.handleByPriority.length; ++n) {
            this.handleByPriority[n] = -1;
        }
        if (this.dataStore.size() > 10000) {
            log.warn((Object)("[" + this.queueDef.getName() + "] Re-creating priority table, this may take a while ... (" + this.dataStore.size() + " messages)"));
        }
        log.debug((Object)("[" + this.queueDef.getName() + "] Scanning datastore to initialize priority table ..."));
        int handle = this.dataStore.first();
        while (handle != -1) {
            int priority = this.retrieveMessagePriority(handle);
            this.handleByPriority[priority] = handle;
            handle = this.dataStore.next(handle);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("[" + this.queueDef.getName() + "] Priority table :"));
            for (int n = 0; n < this.handleByPriority.length; ++n) {
                log.trace((Object)("[" + this.queueDef.getName() + "] Priority " + n + " : " + this.handleByPriority[n]));
            }
        }
        log.debug((Object)("[" + this.queueDef.getName() + "] Scan complete."));
    }

    private int getNearestHandle(int priority) {
        for (int n = priority + 1; n < 10; ++n) {
            int handle = this.handleByPriority[n];
            if (handle == -1) continue;
            return handle;
        }
        return -1;
    }

    private int getLastHandleForPriority(int priority) {
        int lastHandle = this.handleByPriority[priority];
        if (lastHandle != -1) {
            return lastHandle;
        }
        return this.getNearestHandle(priority);
    }

    @Override
    public final int getStoreUsage() {
        return this.dataStore.getStoreUsage();
    }

    @Override
    public final int getAbsoluteStoreUsage() {
        return this.dataStore.getAbsoluteStoreUsage();
    }

    @Override
    public final int previous(int handle) throws JMSException {
        return this.dataStore.previous(handle);
    }

    @Override
    public final void delete(int handle) throws JMSException {
        int previousHandle = this.dataStore.delete(handle);
        for (int n = 0; n < this.handleByPriority.length; ++n) {
            if (this.handleByPriority[n] != handle) continue;
            if (n == 9) {
                this.handleByPriority[n] = previousHandle;
                break;
            }
            if (this.getNearestHandle(n) != previousHandle) {
                this.handleByPriority[n] = previousHandle;
                break;
            }
            this.handleByPriority[n] = -1;
            break;
        }
    }

    @Override
    public final int first() throws JMSException {
        return this.dataStore.first();
    }

    @Override
    public final int next(int handle) throws JMSException {
        return this.dataStore.next(handle);
    }

    @Override
    public final int size() {
        return this.dataStore.size();
    }

    @Override
    public final void commitChanges(SynchronizationBarrier barrier) throws JMSException {
        this.dataStore.commitChanges(barrier);
    }

    @Override
    public final void commitChanges() throws JMSException {
        this.dataStore.commitChanges();
    }

    @Override
    public final void close() {
        this.dataStore.close();
    }

    protected abstract AbstractMessage retrieveMessage(int var1) throws JMSException;

    protected abstract int retrieveMessagePriority(int var1) throws JMSException;

    protected abstract int storeMessage(AbstractMessage var1, int var2) throws JMSException;

    @Override
    public final AbstractMessage retrieve(int handle) throws JMSException {
        return this.retrieveMessage(handle);
    }

    @Override
    public final int replace(int handle, AbstractMessage message) throws JMSException {
        int newHandle = this.replaceMessage(handle, message);
        if (newHandle == -1) {
            return -1;
        }
        if (newHandle != handle) {
            for (int n = 0; n < this.handleByPriority.length; ++n) {
                if (this.handleByPriority[n] != handle) continue;
                this.handleByPriority[n] = newHandle;
                break;
            }
        }
        return newHandle;
    }

    protected abstract int replaceMessage(int var1, AbstractMessage var2) throws JMSException;

    @Override
    public final int store(AbstractMessage message) throws JMSException {
        int priority = message.getJMSPriority();
        int previousHandle = this.getLastHandleForPriority(priority);
        int newHandle = this.storeMessage(message, previousHandle);
        if (newHandle == -1) {
            return -1;
        }
        this.handleByPriority[priority] = newHandle;
        return newHandle;
    }

    @Override
    public final boolean isLocked(int handle) throws JMSException {
        return this.dataStore.isLocked(handle);
    }

    @Override
    public final void lock(int handle) throws JMSException {
        this.dataStore.lock(handle);
    }

    @Override
    public final void unlock(int handle) throws JMSException {
        this.dataStore.unlock(handle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Priority index table :\n");
        sb.append("----------------------\n");
        for (int i = 0; i < this.handleByPriority.length; ++i) {
            sb.append(i);
            sb.append(" - ");
            sb.append(this.handleByPriority[i]);
            sb.append("\n");
        }
        sb.append(this.dataStore);
        return sb.toString();
    }
}

