/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.storage.data.impl.journal;

import java.io.IOException;
import java.io.RandomAccessFile;
import net.timewalker.ffmq4.storage.data.impl.journal.AbstractMetaDataWriteOperation;
import net.timewalker.ffmq4.storage.data.impl.journal.JournalException;
import net.timewalker.ffmq4.storage.data.impl.journal.JournalFile;

public final class MetaDataBlockWriteOperation
extends AbstractMetaDataWriteOperation {
    private byte[] metaData;

    public MetaDataBlockWriteOperation(long transactionId, long metaDataOffset, byte[] metaData) {
        super(transactionId, (byte)3, metaDataOffset);
        this.metaData = metaData;
    }

    public byte[] getMetaData() {
        return this.metaData;
    }

    @Override
    public int size() {
        return super.size() + 4 + this.metaData.length;
    }

    @Override
    protected void writeTo(JournalFile journalFile) throws JournalException {
        super.writeTo(journalFile);
        journalFile.writeInt(this.metaData.length);
        journalFile.write(this.metaData);
    }

    protected int writeTo(RandomAccessFile allocationTableRandomAccessFile) throws JournalException {
        try {
            allocationTableRandomAccessFile.seek(this.offset);
            allocationTableRandomAccessFile.write(this.metaData);
        }
        catch (IOException e) {
            throw new JournalException("Cannot write to store allocation table file", e);
        }
        return this.metaData.length;
    }

    @Override
    public String toString() {
        return super.toString() + " [METADATA_BLOCK] metaDataSize=" + this.metaData.length;
    }
}

