/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.storage.data.impl.journal;

import java.io.IOException;
import java.io.RandomAccessFile;
import net.timewalker.ffmq4.storage.data.impl.journal.AbstractJournalWriteOperation;
import net.timewalker.ffmq4.storage.data.impl.journal.JournalException;
import net.timewalker.ffmq4.storage.data.impl.journal.JournalFile;

public final class DataBlockWriteOperation
extends AbstractJournalWriteOperation {
    private int blockIndex;
    private byte[] blockData;

    public DataBlockWriteOperation(long transactionId, int blockIndex, long blockOffset, byte[] blockData) {
        super(transactionId, (byte)1, blockOffset);
        this.blockIndex = blockIndex;
        this.blockData = blockData;
    }

    public int getBlockIndex() {
        return this.blockIndex;
    }

    public byte[] getBlockData() {
        return this.blockData;
    }

    @Override
    public int size() {
        return super.size() + 4 + this.blockData.length;
    }

    @Override
    protected void writeTo(JournalFile journalFile) throws JournalException {
        super.writeTo(journalFile);
        journalFile.writeInt(this.blockData.length);
        journalFile.write(this.blockData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeTo(RandomAccessFile dataRandomAccessFile) throws JournalException {
        try {
            RandomAccessFile randomAccessFile = dataRandomAccessFile;
            synchronized (randomAccessFile) {
                dataRandomAccessFile.seek(this.offset);
                dataRandomAccessFile.write(this.blockData);
            }
        }
        catch (IOException e) {
            throw new JournalException("Cannot write to store data file", e);
        }
        return this.blockData.length;
    }

    @Override
    public String toString() {
        return super.toString() + " [DATA_BLOCK] blockDataSize=" + this.blockData.length;
    }
}

