/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.local.session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.destination.TemporaryQueueRef;
import net.timewalker.ffmq4.common.destination.TemporaryTopicRef;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.common.session.AbstractSession;
import net.timewalker.ffmq4.local.FFMQEngine;
import net.timewalker.ffmq4.local.MessageLock;
import net.timewalker.ffmq4.local.MessageLockSet;
import net.timewalker.ffmq4.local.TransactionItem;
import net.timewalker.ffmq4.local.TransactionSet;
import net.timewalker.ffmq4.local.connection.LocalConnection;
import net.timewalker.ffmq4.local.destination.AbstractLocalDestination;
import net.timewalker.ffmq4.local.destination.LocalQueue;
import net.timewalker.ffmq4.local.destination.notification.NotificationProxy;
import net.timewalker.ffmq4.local.session.LocalDurableTopicSubscriber;
import net.timewalker.ffmq4.local.session.LocalMessageConsumer;
import net.timewalker.ffmq4.local.session.LocalMessageProducer;
import net.timewalker.ffmq4.local.session.LocalQueueBrowser;
import net.timewalker.ffmq4.utils.Committable;
import net.timewalker.ffmq4.utils.ErrorTools;
import net.timewalker.ffmq4.utils.StringTools;
import net.timewalker.ffmq4.utils.concurrent.SynchronizationBarrier;
import net.timewalker.ffmq4.utils.id.IntegerID;
import net.timewalker.ffmq4.utils.id.UUIDProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalSession
extends AbstractSession {
    private static final Log log = LogFactory.getLog(LocalSession.class);
    protected FFMQEngine engine;
    private List<AbstractMessage> pendingPuts = new Vector<AbstractMessage>();
    private TransactionSet transactionSet = new TransactionSet();
    private boolean debugEnabled = log.isDebugEnabled();
    protected NotificationProxy notificationProxy;
    private long consumedCount;
    private long producedCount;
    private static final DestinationComparator DESTINATION_COMPARATOR = new DestinationComparator();

    public LocalSession(IntegerID id, LocalConnection connection, FFMQEngine engine, boolean transacted, int acknowlegdeMode) {
        super(id, connection, transacted, acknowlegdeMode);
        this.engine = engine;
    }

    public final void setNotificationProxy(NotificationProxy notificationProxy) {
        this.notificationProxy = notificationProxy;
    }

    public final NotificationProxy getNotificationProxy() {
        return this.notificationProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispatch(AbstractMessage message) throws JMSException {
        LocalConnection conn = (LocalConnection)this.getConnection();
        if (conn.isSecurityEnabled()) {
            Destination destination = message.getJMSDestination();
            if (destination instanceof Queue) {
                String queueName = ((Queue)destination).getQueueName();
                if (!conn.isRegisteredTemporaryQueue(queueName)) {
                    if (queueName.equals("_FFMQ_ADM_REQUEST")) {
                        conn.checkPermission("server", "remoteAdmin");
                    } else if (queueName.equals("_FFMQ_ADM_REPLY")) {
                        if (conn.getSecurityContext() != null) {
                            throw new FFMQException("Access denied to administration queue " + queueName, "ACCESS_DENIED");
                        }
                    } else {
                        conn.checkPermission(destination, "produce");
                    }
                }
            } else if (destination instanceof Topic) {
                String topicName = ((Topic)destination).getTopicName();
                if (!conn.isRegisteredTemporaryTopic(topicName)) {
                    conn.checkPermission(destination, "produce");
                }
            } else {
                throw new InvalidDestinationException("Unsupported destination : " + destination);
            }
        }
        if (this.debugEnabled) {
            log.debug((Object)(this + " [PUT] in " + message.getJMSDestination() + " - " + message));
        }
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            this.pendingPuts.add(message);
            if (!this.transacted) {
                this.commitUpdates(false, null, true);
            }
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public final void commit() throws JMSException {
        this.commit(true, null);
    }

    public final void commit(boolean commitGets, List<String> deliveredMessageIDs) throws JMSException {
        if (!this.transacted) {
            throw new IllegalStateException("Session is not transacted");
        }
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            this.commitUpdates(commitGets, deliveredMessageIDs, true);
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public final void rollback() throws JMSException {
        this.rollback(true, null);
    }

    public final void rollback(boolean rollbackGets, List<String> deliveredMessageIDs) throws JMSException {
        if (!this.transacted) {
            throw new IllegalStateException("Session is not transacted");
        }
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            this.rollbackUpdates(true, rollbackGets, deliveredMessageIDs);
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public final void rollbackUndelivered(List<String> undeliveredMessageIDs) throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            this.rollbackUpdates(false, true, undeliveredMessageIDs);
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    private AbstractLocalDestination getLocalDestination(AbstractMessage message) throws JMSException {
        Destination destination = message.getJMSDestination();
        if (destination instanceof Queue) {
            Queue queueRef = (Queue)destination;
            return this.engine.getLocalQueue(queueRef.getQueueName());
        }
        if (destination instanceof Topic) {
            Topic topicRef = (Topic)destination;
            return this.engine.getLocalTopic(topicRef.getTopicName());
        }
        throw new InvalidDestinationException("Unsupported destination : " + destination);
    }

    private List<Committable> computeLocalTargetDestinations(List<AbstractMessage> pendingPuts, List<LocalQueue> queuesWithGet) throws JMSException {
        int initialSize = Math.max((pendingPuts != null ? pendingPuts.size() : 0) + (queuesWithGet != null ? queuesWithGet.size() : 0), 16);
        ArrayList<Committable> targetCommitables = new ArrayList<Committable>(initialSize);
        if (queuesWithGet != null) {
            targetCommitables.addAll(queuesWithGet);
        }
        if (pendingPuts != null) {
            for (int i = 0; i < pendingPuts.size(); ++i) {
                AbstractMessage msg = pendingPuts.get(i);
                AbstractLocalDestination destination = this.getLocalDestination(msg);
                if (targetCommitables.contains(destination)) continue;
                targetCommitables.add(destination);
            }
        }
        Collections.sort(targetCommitables, DESTINATION_COMPARATOR);
        return targetCommitables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void commitUpdates(boolean commitGets, List<String> deliveredMessageIDs, boolean commitPuts) throws JMSException {
        int i;
        List<Committable> targetDestinations;
        SynchronizationBarrier commitBarrier = null;
        List<LocalQueue> queuesWithGet = null;
        MessageLockSet locks = null;
        JMSException putFailure = null;
        HashSet<AbstractLocalDestination> committables = new HashSet<AbstractLocalDestination>();
        if (commitGets && this.transactionSet.size() > 0) {
            queuesWithGet = deliveredMessageIDs != null ? this.transactionSet.updatedQueues(deliveredMessageIDs) : this.transactionSet.updatedQueues();
        }
        try {
            targetDestinations = this.computeLocalTargetDestinations(commitPuts ? this.pendingPuts : null, queuesWithGet);
        }
        catch (FFMQException e) {
            if (commitPuts && !this.transacted) {
                this.pendingPuts.clear();
                ErrorTools.log(e, log);
            }
            throw e;
        }
        for (int i2 = 0; i2 < targetDestinations.size(); ++i2) {
            Committable committable = targetDestinations.get(i2);
            committable.openTransaction();
        }
        try {
            if (commitPuts) {
                List<AbstractMessage> i2 = this.pendingPuts;
                synchronized (i2) {
                    if (!this.pendingPuts.isEmpty()) {
                        int n = this.pendingPuts.size();
                        locks = new MessageLockSet(n);
                        if (this.debugEnabled) {
                            log.debug((Object)(this + " - COMMIT [PUT] " + this.pendingPuts.size() + " message(s)"));
                        }
                        int produced = 0;
                        try {
                            for (int i3 = 0; i3 < n; ++i3) {
                                AbstractMessage message = this.pendingPuts.get(i3);
                                AbstractLocalDestination targetDestination = this.getLocalDestination(message);
                                if (targetDestination.putLocked(message, this, locks)) {
                                    committables.add(targetDestination);
                                }
                                ++produced;
                            }
                            this.pendingPuts.clear();
                        }
                        catch (JMSException e) {
                            if (this.transacted) {
                                for (int i4 = 0; i4 < locks.size(); ++i4) {
                                    MessageLock item = locks.get(i4);
                                    item.getDestination().removeLocked(item);
                                }
                                produced = 0;
                                putFailure = e;
                            }
                            this.pendingPuts.clear();
                            ErrorTools.log(e, log);
                            putFailure = e;
                        }
                        this.producedCount += (long)produced;
                    }
                }
            }
            if (queuesWithGet != null && putFailure == null) {
                void var11_20;
                TransactionItem[] pendingGets;
                if (deliveredMessageIDs != null) {
                    if (this.debugEnabled) {
                        log.debug((Object)(this + " - COMMIT [GET] " + deliveredMessageIDs.size() + " message(s)"));
                    }
                    pendingGets = this.transactionSet.clear(deliveredMessageIDs);
                } else {
                    if (this.debugEnabled) {
                        log.debug((Object)(this + " - COMMIT [GET] " + this.transactionSet.size() + " message(s)"));
                    }
                    pendingGets = this.transactionSet.clear();
                }
                boolean bl = false;
                while (var11_20 < queuesWithGet.size()) {
                    LocalQueue localQueue = queuesWithGet.get((int)var11_20);
                    if (localQueue.remove(this, pendingGets)) {
                        committables.add(localQueue);
                    }
                    ++this.consumedCount;
                    ++var11_20;
                }
            }
            if (committables.size() > 0) {
                commitBarrier = new SynchronizationBarrier();
                for (Committable committable : committables) {
                    committable.commitChanges(commitBarrier);
                }
            }
        }
        finally {
            for (i = 0; i < targetDestinations.size(); ++i) {
                Committable committable = targetDestinations.get(i);
                committable.closeTransaction();
            }
        }
        if (putFailure != null) {
            throw putFailure;
        }
        if (commitBarrier != null) {
            try {
                commitBarrier.waitFor();
            }
            catch (InterruptedException e) {
                throw new JMSException("Commit barrier was interrupted");
            }
        }
        if (locks != null) {
            for (i = 0; i < locks.size(); ++i) {
                MessageLock messageLock = locks.get(i);
                messageLock.getDestination().unlockAndDeliver(messageLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackUpdates(boolean rollbackPuts, boolean rollbackGets, List<String> deliveredMessageIDs) throws JMSException {
        if (rollbackPuts && this.transacted && !this.pendingPuts.isEmpty()) {
            if (this.debugEnabled) {
                log.debug((Object)(this + " - ROLLBACK [PUT] " + this.pendingPuts.size() + " message(s)"));
            }
            this.pendingPuts.clear();
        }
        if (rollbackGets && this.transactionSet.size() > 0) {
            int i;
            TransactionItem[] pendingGets;
            SynchronizationBarrier commitBarrier = null;
            HashSet<LocalQueue> committables = new HashSet<LocalQueue>();
            if (deliveredMessageIDs != null) {
                if (this.debugEnabled) {
                    log.debug((Object)(this + " - ROLLBACK [GET] " + deliveredMessageIDs.size() + " message(s)"));
                }
                pendingGets = this.transactionSet.clear(deliveredMessageIDs);
            } else {
                if (this.debugEnabled) {
                    log.debug((Object)(this + " - ROLLBACK [GET] " + this.transactionSet.size() + " message(s)"));
                }
                pendingGets = this.transactionSet.clear();
            }
            List<LocalQueue> queuesWithGet = this.computeUpdatedQueues(pendingGets);
            MessageLockSet locks = new MessageLockSet(pendingGets.length);
            List<Committable> targetDestinations = this.computeLocalTargetDestinations(null, queuesWithGet);
            for (int i2 = 0; i2 < targetDestinations.size(); ++i2) {
                Committable committable = targetDestinations.get(i2);
                committable.openTransaction();
            }
            try {
                for (int i2 = 0; i2 < queuesWithGet.size(); ++i2) {
                    LocalQueue localQueue = queuesWithGet.get(i2);
                    if (!localQueue.redeliverLocked(pendingGets, locks)) continue;
                    committables.add(localQueue);
                }
                if (committables.size() > 0) {
                    commitBarrier = new SynchronizationBarrier();
                    for (Committable committable : committables) {
                        committable.commitChanges(commitBarrier);
                    }
                }
            }
            finally {
                for (i = 0; i < targetDestinations.size(); ++i) {
                    Committable committable = targetDestinations.get(i);
                    committable.closeTransaction();
                }
            }
            if (commitBarrier != null) {
                try {
                    commitBarrier.waitFor();
                }
                catch (InterruptedException e) {
                    throw new JMSException("Commit barrier was interrupted");
                }
            }
            for (i = 0; i < locks.size(); ++i) {
                MessageLock messageLock = locks.get(i);
                messageLock.getDestination().unlockAndDeliver(messageLock);
            }
        }
    }

    private List<LocalQueue> computeUpdatedQueues(TransactionItem[] pendingGets) {
        ArrayList<LocalQueue> updatedQueues = new ArrayList<LocalQueue>(Math.max(pendingGets.length, 16));
        for (int i = 0; i < pendingGets.length; ++i) {
            LocalQueue localQueue = pendingGets[i].getDestination();
            if (updatedQueues.contains(localQueue)) continue;
            updatedQueues.add(localQueue);
        }
        return updatedQueues;
    }

    private boolean hasPendingUpdates() {
        return this.transactionSet.size() > 0 || this.pendingPuts.size() > 0;
    }

    protected final TransactionSet getTransactionSet() {
        return this.transactionSet;
    }

    @Override
    protected void onSessionClose() {
        try {
            if (this.hasPendingUpdates()) {
                this.rollbackUpdates(true, true, null);
            }
        }
        catch (JMSException e) {
            ErrorTools.log(e, log);
        }
        super.onSessionClose();
    }

    public QueueBrowser createBrowser(Queue queueRef, String messageSelector) throws JMSException {
        return this.createBrowser(this.idProvider.createID(), queueRef, messageSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueBrowser createBrowser(IntegerID browserId, Queue queueRef, String messageSelector) throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            LocalQueue localQueue = this.engine.getLocalQueue(queueRef.getQueueName());
            this.checkTemporaryDestinationScope(localQueue);
            LocalQueueBrowser browser = new LocalQueueBrowser(this, localQueue, messageSelector, browserId);
            this.registerBrowser(browser);
            LocalQueueBrowser localQueueBrowser = browser;
            return localQueueBrowser;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        return this.createConsumer(this.idProvider.createID(), destination, messageSelector, noLocal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(IntegerID consumerId, Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            LocalMessageConsumer consumer = new LocalMessageConsumer(this.engine, this, destination, messageSelector, noLocal, consumerId, null);
            this.registerConsumer(consumer);
            consumer.initDestination();
            LocalMessageConsumer localMessageConsumer = consumer;
            return localMessageConsumer;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String subscriptionName, String messageSelector, boolean noLocal) throws JMSException {
        return this.createDurableSubscriber(this.idProvider.createID(), topic, subscriptionName, messageSelector, noLocal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(IntegerID consumerId, Topic topic, String subscriptionName, String messageSelector, boolean noLocal) throws JMSException {
        if (StringTools.isEmpty(subscriptionName)) {
            throw new FFMQException("Empty subscription name", "INVALID_SUBSCRIPTION_NAME");
        }
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            String clientID = this.connection.getClientID();
            String subscriberId = clientID + "-" + subscriptionName;
            LocalDurableTopicSubscriber subscriber = new LocalDurableTopicSubscriber(this.engine, this, (Destination)topic, messageSelector, noLocal, consumerId, subscriberId);
            this.registerConsumer(subscriber);
            subscriber.initDestination();
            this.engine.subscribe(clientID, subscriptionName);
            LocalDurableTopicSubscriber localDurableTopicSubscriber = subscriber;
            return localDurableTopicSubscriber;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            LocalMessageProducer producer = new LocalMessageProducer(this, destination, this.idProvider.createID());
            this.registerProducer(producer);
            LocalMessageProducer localMessageProducer = producer;
            return localMessageProducer;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public final void recover() throws JMSException {
        this.recover(null);
    }

    public final void recover(List<String> deliveredMessageIDs) throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            if (this.transacted) {
                throw new IllegalStateException("Session is transacted");
            }
            this.rollbackUpdates(true, true, deliveredMessageIDs);
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public void unsubscribe(String subscriptionName) throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            if (StringTools.isEmpty(subscriptionName)) {
                throw new FFMQException("Empty subscription name", "INVALID_SUBSCRIPTION_NAME");
            }
            this.engine.unsubscribe(this.connection.getClientID(), subscriptionName);
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            String queueName = "TEMP-QUEUE-" + UUIDProvider.getInstance().getShortUUID();
            this.engine.createTemporaryQueue(queueName);
            this.connection.registerTemporaryQueue(queueName);
            TemporaryQueueRef temporaryQueueRef = new TemporaryQueueRef(this.connection, queueName);
            return temporaryQueueRef;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            String topicName = "TEMP-TOPIC-" + UUIDProvider.getInstance().getShortUUID();
            this.engine.createTemporaryTopic(topicName);
            this.connection.registerTemporaryTopic(topicName);
            TemporaryTopicRef temporaryTopicRef = new TemporaryTopicRef(this.connection, topicName);
            return temporaryTopicRef;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    @Override
    public final void acknowledge() throws JMSException {
        this.acknowledge(null);
    }

    public final void acknowledge(List<String> deliveredMessageIDs) throws JMSException {
        if (this.transacted) {
            throw new IllegalStateException("Session is transacted");
        }
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            this.commitUpdates(true, deliveredMessageIDs, false);
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    protected final void deleteQueue(String queueName) throws JMSException {
        this.transactionSet.removeUpdatesForQueue(queueName);
        this.engine.deleteQueue(queueName);
    }

    public final long getProducedCount() {
        return this.producedCount;
    }

    public final long getConsumedCount() {
        return this.consumedCount;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("(consumed=");
        sb.append(this.consumedCount);
        sb.append(",produced=");
        sb.append(this.producedCount);
        sb.append(")");
        return sb.toString();
    }

    private static final class DestinationComparator
    implements Comparator<Committable> {
        @Override
        public int compare(Committable c1, Committable c2) {
            int delta = c1.getName().compareTo(c2.getName());
            if (delta != 0) {
                return delta;
            }
            return c1.getClass().getName().compareTo(c2.getClass().getName());
        }
    }
}

