/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.local.session;

import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.destination.TemporaryDestination;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.common.message.MessageTools;
import net.timewalker.ffmq4.common.session.AbstractMessageProducer;
import net.timewalker.ffmq4.local.connection.LocalConnection;
import net.timewalker.ffmq4.local.session.LocalSession;
import net.timewalker.ffmq4.utils.id.IntegerID;

public class LocalMessageProducer
extends AbstractMessageProducer {
    public LocalMessageProducer(LocalSession session, Destination destination, IntegerID producerId) throws JMSException {
        super(session, destination, producerId);
        this.session = session;
        if (destination != null) {
            this.checkDestinationPermission(destination);
        }
    }

    private final void checkDestinationPermission(Destination destination) throws JMSException {
        if (!(destination instanceof TemporaryDestination)) {
            boolean adminRequest = false;
            if (destination instanceof Queue) {
                String queueName = ((Queue)destination).getQueueName();
                if (queueName.equals("_FFMQ_ADM_REQUEST")) {
                    LocalConnection conn = (LocalConnection)this.session.getConnection();
                    conn.checkPermission("server", "remoteAdmin");
                    adminRequest = true;
                } else if (queueName.equals("_FFMQ_ADM_REPLY")) {
                    LocalConnection conn = (LocalConnection)this.session.getConnection();
                    if (conn.getSecurityContext() != null) {
                        throw new FFMQException("Access denied to administration queue " + queueName, "ACCESS_DENIED");
                    }
                    adminRequest = true;
                }
            }
            if (!adminRequest) {
                ((LocalConnection)this.session.getConnection()).checkPermission(destination, "produce");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void sendToDestination(Destination destination, boolean destinationOverride, Message srcMessage, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (destination == null) {
            throw new InvalidDestinationException("Destination not specified");
        }
        AbstractMessage message = MessageTools.makeInternalCopy(srcMessage);
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            ((LocalSession)this.session).dispatch(message);
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }
}

