/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.session;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.connection.AbstractConnection;
import net.timewalker.ffmq4.common.destination.QueueRef;
import net.timewalker.ffmq4.common.destination.TopicRef;
import net.timewalker.ffmq4.common.message.BytesMessageImpl;
import net.timewalker.ffmq4.common.message.EmptyMessageImpl;
import net.timewalker.ffmq4.common.message.MapMessageImpl;
import net.timewalker.ffmq4.common.message.ObjectMessageImpl;
import net.timewalker.ffmq4.common.message.StreamMessageImpl;
import net.timewalker.ffmq4.common.message.TextMessageImpl;
import net.timewalker.ffmq4.common.session.AbstractMessageConsumer;
import net.timewalker.ffmq4.common.session.AbstractMessageHandler;
import net.timewalker.ffmq4.common.session.AbstractMessageProducer;
import net.timewalker.ffmq4.common.session.AbstractQueueBrowser;
import net.timewalker.ffmq4.local.destination.LocalQueue;
import net.timewalker.ffmq4.local.destination.LocalTopic;
import net.timewalker.ffmq4.utils.id.IntegerID;
import net.timewalker.ffmq4.utils.id.IntegerIDProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractSession
implements Session {
    private static final Log log = LogFactory.getLog(AbstractSession.class);
    protected AbstractConnection connection;
    protected IntegerID id;
    protected boolean transacted;
    protected int acknowledgeMode;
    protected boolean closed;
    public Object deliveryLock = new Object();
    protected Map<IntegerID, AbstractMessageConsumer> consumersMap = new Hashtable<IntegerID, AbstractMessageConsumer>();
    private Map<IntegerID, AbstractMessageProducer> producersMap = new Hashtable<IntegerID, AbstractMessageProducer>();
    private Map<IntegerID, AbstractQueueBrowser> browsersMap = new Hashtable<IntegerID, AbstractQueueBrowser>();
    protected IntegerIDProvider idProvider = new IntegerIDProvider();
    protected ReadWriteLock externalAccessLock = new ReentrantReadWriteLock();

    public AbstractSession(AbstractConnection connection, boolean transacted, int acknowledgeMode) {
        this.connection = connection;
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
    }

    public AbstractSession(IntegerID id, AbstractConnection connection, boolean transacted, int acknowledgeMode) {
        this(connection, transacted, acknowledgeMode);
        this.id = id;
    }

    public final IntegerID getId() {
        return this.id;
    }

    protected final void checkNotClosed() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Session is closed");
        }
    }

    public final void close() throws JMSException {
        this.externalAccessLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.onSessionClose();
        }
        finally {
            this.externalAccessLock.writeLock().unlock();
        }
        this.onSessionClosed();
    }

    protected void onSessionClose() {
        this.connection.unregisterSession(this);
        this.closeRemainingConsumers();
        this.closeRemainingProducers();
        this.closeRemainingBrowsers();
    }

    protected void onSessionClosed() {
    }

    public final void checkTemporaryDestinationScope(Destination destination) throws JMSException {
        if (destination instanceof LocalQueue) {
            LocalQueue localQueue = (LocalQueue)destination;
            if (localQueue.isTemporary() && !this.connection.isRegisteredTemporaryQueue(localQueue.getQueueName())) {
                throw new IllegalStateException("Temporary queue does not belong to session's connection.");
            }
        } else if (destination instanceof LocalTopic) {
            LocalTopic localTopic = (LocalTopic)destination;
            if (localTopic.isTemporary() && !this.connection.isRegisteredTemporaryTopic(localTopic.getTopicName())) {
                throw new IllegalStateException("Temporary topic does not belong to session's connection.");
            }
        } else {
            throw new FFMQException("Unexpected destination type : " + destination, "INTERNAL_ERROR");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wakeUpConsumers() throws JMSException {
        Map<IntegerID, AbstractMessageConsumer> map = this.consumersMap;
        synchronized (map) {
            for (AbstractMessageConsumer consumer : this.consumersMap.values()) {
                consumer.wakeUp();
            }
        }
    }

    public final AbstractMessageConsumer lookupRegisteredConsumer(IntegerID consumerId) {
        return this.consumersMap.get(consumerId);
    }

    public final AbstractQueueBrowser lookupRegisteredBrowser(IntegerID browserId) {
        return this.browsersMap.get(browserId);
    }

    protected final void registerConsumer(AbstractMessageConsumer consumer) {
        if (this.consumersMap.put(consumer.getId(), consumer) != null) {
            throw new IllegalArgumentException("Consumer " + consumer.getId() + " already exists");
        }
    }

    protected final void registerProducer(AbstractMessageProducer producer) {
        if (this.producersMap.put(producer.getId(), producer) != null) {
            throw new IllegalArgumentException("Producer " + producer.getId() + " already exists");
        }
    }

    protected final void registerBrowser(AbstractQueueBrowser browser) {
        if (this.browsersMap.put(browser.getId(), browser) != null) {
            throw new IllegalArgumentException("Browser " + browser.getId() + " already exists");
        }
    }

    protected final void unregisterConsumer(AbstractMessageConsumer consumerToRemove) {
        if (this.consumersMap.remove(consumerToRemove.getId()) == null) {
            log.warn((Object)("Unknown consumer : " + consumerToRemove));
        }
    }

    protected final void unregisterProducer(AbstractMessageProducer producerToRemove) {
        if (this.producersMap.remove(producerToRemove.getId()) == null) {
            log.warn((Object)("Unknown producer : " + producerToRemove));
        }
    }

    protected final void unregisterBrowser(AbstractQueueBrowser browserToRemove) {
        if (this.browsersMap.remove(browserToRemove.getId()) == null) {
            log.warn((Object)("Unknown browser : " + browserToRemove));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeRemainingConsumers() {
        ArrayList<AbstractMessageConsumer> consumersToClose = new ArrayList<AbstractMessageConsumer>(this.consumersMap.size());
        Map<IntegerID, AbstractMessageConsumer> map = this.consumersMap;
        synchronized (map) {
            consumersToClose.addAll(this.consumersMap.values());
        }
        for (int n = 0; n < consumersToClose.size(); ++n) {
            MessageConsumer consumer = (MessageConsumer)consumersToClose.get(n);
            log.debug((Object)("Auto-closing unclosed consumer : " + consumer));
            try {
                consumer.close();
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Could not close consumer " + consumer), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeRemainingProducers() {
        ArrayList<AbstractMessageProducer> producersToClose = new ArrayList<AbstractMessageProducer>(this.producersMap.size());
        Map<IntegerID, AbstractMessageProducer> map = this.producersMap;
        synchronized (map) {
            producersToClose.addAll(this.producersMap.values());
        }
        for (int n = 0; n < producersToClose.size(); ++n) {
            MessageProducer producer = (MessageProducer)producersToClose.get(n);
            log.debug((Object)("Auto-closing unclosed producer : " + producer));
            try {
                producer.close();
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Could not close producer " + producer), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeRemainingBrowsers() {
        ArrayList<AbstractQueueBrowser> browsersToClose = new ArrayList<AbstractQueueBrowser>(this.browsersMap.size());
        Map<IntegerID, AbstractQueueBrowser> map = this.browsersMap;
        synchronized (map) {
            browsersToClose.addAll(this.browsersMap.values());
        }
        for (int n = 0; n < browsersToClose.size(); ++n) {
            QueueBrowser browser = (QueueBrowser)browsersToClose.get(n);
            log.debug((Object)("Auto-closing unclosed browser : " + browser));
            try {
                browser.close();
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Could not close browser " + browser), (Throwable)e);
            }
        }
    }

    public abstract void acknowledge() throws JMSException;

    public final Message createMessage() throws JMSException {
        return new EmptyMessageImpl();
    }

    public final BytesMessage createBytesMessage() throws JMSException {
        return new BytesMessageImpl();
    }

    public final MapMessage createMapMessage() throws JMSException {
        return new MapMessageImpl();
    }

    public final ObjectMessage createObjectMessage() throws JMSException {
        return new ObjectMessageImpl();
    }

    public final StreamMessage createStreamMessage() throws JMSException {
        return new StreamMessageImpl();
    }

    public final TextMessage createTextMessage() throws JMSException {
        return new TextMessageImpl();
    }

    public Queue createQueue(String queueName) throws JMSException {
        return new QueueRef(queueName);
    }

    public final int getAcknowledgeMode() throws JMSException {
        if (this.transacted) {
            return 0;
        }
        return this.acknowledgeMode;
    }

    public final boolean getTransacted() throws JMSException {
        return this.transacted;
    }

    public final ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return new ObjectMessageImpl(object);
    }

    public final TextMessage createTextMessage(String text) throws JMSException {
        return new TextMessageImpl(text);
    }

    public final MessageListener getMessageListener() throws JMSException {
        throw new FFMQException("Unsupported feature", "UNSUPPORTED_FEATURE");
    }

    public final void setMessageListener(MessageListener listener) throws JMSException {
        throw new FFMQException("Unsupported feature", "UNSUPPORTED_FEATURE");
    }

    public Topic createTopic(String topicName) throws JMSException {
        return new TopicRef(topicName);
    }

    public final MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    public final MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    public final void run() {
    }

    public final AbstractConnection getConnection() {
        return this.connection;
    }

    public final int getConsumersCount() {
        return this.consumersMap.size();
    }

    public final int getProducersCount() {
        return this.producersMap.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Session[#");
        sb.append(this.id);
        sb.append("](");
        if (this.transacted) {
            sb.append("transacted");
        } else {
            sb.append("not transacted, acknowledgeMode=");
            sb.append(this.acknowledgeMode);
        }
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getEntitiesDescription(StringBuilder sb) {
        int pos;
        sb.append(this.toString());
        sb.append("{");
        Map<IntegerID, AbstractMessageHandler> map = this.consumersMap;
        synchronized (map) {
            if (!this.consumersMap.isEmpty()) {
                pos = 0;
                for (AbstractMessageHandler abstractMessageHandler : this.consumersMap.values()) {
                    if (pos++ > 0) {
                        sb.append(",");
                    }
                    abstractMessageHandler.getEntitiesDescription(sb);
                }
            }
        }
        map = this.producersMap;
        synchronized (map) {
            if (!this.producersMap.isEmpty()) {
                pos = 0;
                for (AbstractMessageHandler abstractMessageHandler : this.producersMap.values()) {
                    if (pos++ > 0) {
                        sb.append(",");
                    }
                    abstractMessageHandler.getEntitiesDescription(sb);
                }
            }
        }
        sb.append("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForDeliverySync() {
        Object object = this.deliveryLock;
        synchronized (object) {
        }
    }
}

