/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.session;

import java.util.Enumeration;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.common.session.AbstractQueueBrowser;
import net.timewalker.ffmq4.utils.JavaTools;

public abstract class AbstractQueueBrowserEnumeration
implements Enumeration<AbstractMessage> {
    protected String id;
    protected AbstractQueueBrowser browser;
    protected Object closeLock = new Object();
    protected boolean closed;

    public AbstractQueueBrowserEnumeration(AbstractQueueBrowser browser, String enumId) {
        this.id = enumId;
        this.browser = browser;
    }

    public final String getId() {
        return this.id;
    }

    public final void checkNotClosed() throws JMSException {
        if (this.closed) {
            throw new FFMQException("Queue browser enumeration is closed", "ENUMERATION_CLOSED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.onQueueBrowserEnumerationClose();
        }
    }

    protected void onQueueBrowserEnumerationClose() {
        this.browser.unregisterEnumeration(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(JavaTools.getShortClassName(this.getClass()));
        sb.append("[#");
        sb.append(this.id);
        sb.append("]");
        return sb.toString();
    }
}

