/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message.selector.expression.operator;

import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import net.timewalker.ffmq4.common.message.selector.expression.ArithmeticExpression;
import net.timewalker.ffmq4.common.message.selector.expression.ConditionalExpression;
import net.timewalker.ffmq4.common.message.selector.expression.SelectorNode;
import net.timewalker.ffmq4.common.message.selector.expression.utils.ArithmeticUtils;

public class BetweenOperator
extends SelectorNode
implements ConditionalExpression {
    protected SelectorNode leftOperand;
    protected SelectorNode lowerBoundOperand;
    protected SelectorNode upperBoundOperand;

    public BetweenOperator(SelectorNode leftOperand, SelectorNode lowerBoundOperand, SelectorNode upperBoundOperand) throws InvalidSelectorException {
        this.leftOperand = leftOperand;
        this.lowerBoundOperand = lowerBoundOperand;
        this.upperBoundOperand = upperBoundOperand;
        if (!(leftOperand instanceof ArithmeticExpression)) {
            throw new InvalidSelectorException("left operand of BETWEEN operator must be an arithmetic expression");
        }
        if (!(lowerBoundOperand instanceof ArithmeticExpression)) {
            throw new InvalidSelectorException("lower bound of BETWEEN operator must be an arithmetic expression");
        }
        if (!(upperBoundOperand instanceof ArithmeticExpression)) {
            throw new InvalidSelectorException("upper bound of BETWEEN operator must be an arithmetic expression");
        }
    }

    @Override
    public Object evaluate(Message message) throws JMSException {
        Number value = this.leftOperand.evaluateNumeric(message);
        Number lowerBound = this.lowerBoundOperand.evaluateNumeric(message);
        Number upperBound = this.upperBoundOperand.evaluateNumeric(message);
        if (value == null || lowerBound == null || upperBound == null) {
            return null;
        }
        return ArithmeticUtils.greaterThanOrEquals(value, lowerBound) != false && ArithmeticUtils.lessThanOrEquals(value, upperBound) != false ? Boolean.TRUE : Boolean.FALSE;
    }

    public String toString() {
        return this.parenthesize(this.leftOperand) + " BETWEEN " + this.parenthesize(this.lowerBoundOperand) + " AND " + this.parenthesize(this.upperBoundOperand);
    }
}

