/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.utils.RawDataBuffer;

public final class BytesMessageImpl
extends AbstractMessage
implements BytesMessage {
    private byte[] body;
    private transient DataInputStream input;
    private transient DataOutputStream output;
    private transient ByteArrayInputStream inputBuf;
    private transient ByteArrayOutputStream outputBuf;

    private void tidyUp() {
        if (this.outputBuf != null) {
            this.body = this.outputBuf.toByteArray();
            this.outputBuf = null;
        }
        this.output = null;
        this.inputBuf = null;
        this.input = null;
    }

    @Override
    protected byte getType() {
        return 2;
    }

    @Override
    protected void unserializeBodyFrom(RawDataBuffer in) {
        this.body = in.readNullableByteArray();
    }

    @Override
    protected void serializeBodyTo(RawDataBuffer out) {
        this.tidyUp();
        out.writeNullableByteArray(this.body);
    }

    private void backupState() {
        if (this.inputBuf != null) {
            this.inputBuf.mark(-1);
        }
    }

    private void restoreState() {
        if (this.inputBuf != null) {
            this.inputBuf.reset();
        }
    }

    private DataInputStream getInput() throws JMSException {
        if (!this.bodyIsReadOnly) {
            throw new MessageNotReadableException("Message body is write-only");
        }
        if (this.input == null) {
            this.inputBuf = new ByteArrayInputStream(this.body != null ? this.body : new byte[]{});
            this.input = new DataInputStream(this.inputBuf);
        }
        return this.input;
    }

    private DataOutputStream getOutput() throws JMSException {
        if (this.bodyIsReadOnly) {
            throw new MessageNotWriteableException("Message body is read-only");
        }
        if (this.output == null) {
            this.outputBuf = new ByteArrayOutputStream(1024);
            this.output = new DataOutputStream(this.outputBuf);
        }
        return this.output;
    }

    public void clearBody() {
        this.assertDeserializationLevel(3);
        this.body = null;
        this.input = null;
        this.output = null;
        this.inputBuf = null;
        this.outputBuf = null;
        this.bodyIsReadOnly = false;
    }

    public long getBodyLength() throws JMSException {
        if (!this.bodyIsReadOnly) {
            throw new MessageNotReadableException("Message body is write-only");
        }
        return this.body != null ? (long)this.body.length : 0L;
    }

    public boolean readBoolean() throws JMSException {
        this.backupState();
        try {
            return this.getInput().readBoolean();
        }
        catch (EOFException e) {
            this.restoreState();
            throw new MessageEOFException("End of body reached");
        }
        catch (IOException e) {
            this.restoreState();
            throw new FFMQException("Cannot read message body", "IO_ERROR", e);
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public byte readByte() throws JMSException {
        this.backupState();
        try {
            return this.getInput().readByte();
        }
        catch (EOFException e) {
            this.restoreState();
            throw new MessageEOFException("End of body reached");
        }
        catch (IOException e) {
            this.restoreState();
            throw new FFMQException("Cannot read message body", "IO_ERROR", e);
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        this.backupState();
        try {
            return this.getInput().read(value);
        }
        catch (EOFException e) {
            this.restoreState();
            throw new MessageEOFException("End of body reached");
        }
        catch (IOException e) {
            this.restoreState();
            throw new FFMQException("Cannot read message body", "IO_ERROR", e);
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.backupState();
        try {
            return this.getInput().read(value, 0, length);
        }
        catch (EOFException e) {
            this.restoreState();
            throw new MessageEOFException("End of body reached");
        }
        catch (IOException e) {
            this.restoreState();
            throw new FFMQException("Cannot read message body", "IO_ERROR", e);
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public char readChar() throws JMSException {
        this.backupState();
        try {
            return this.getInput().readChar();
        }
        catch (EOFException e) {
            this.restoreState();
            throw new MessageEOFException("End of body reached");
        }
        catch (IOException e) {
            this.restoreState();
            throw new FFMQException("Cannot read message body", "IO_ERROR", e);
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public double readDouble() throws JMSException {
        this.backupState();
        try {
            return this.getInput().readDouble();
        }
        catch (EOFException e) {
            this.restoreState();
            throw new MessageEOFException("End of body reached");
        }
        catch (IOException e) {
            this.restoreState();
            throw new FFMQException("Cannot read message body", "IO_ERROR", e);
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public float readFloat() throws JMSException {
        this.backupState();
        try {
            return this.getInput().readFloat();
        }
        catch (EOFException e) {
            this.restoreState();
            throw new MessageEOFException("End of body reached");
        }
        catch (IOException e) {
            this.restoreState();
            throw new FFMQException("Cannot read message body", "IO_ERROR", e);
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public int readInt() throws JMSException {
        this.backupState();
        try {
            return this.getInput().readInt();
        }
        catch (EOFException e) {
            this.restoreState();
            throw new MessageEOFException("End of body reached");
        }
        catch (IOException e) {
            this.restoreState();
            throw new FFMQException("Cannot read message body", "IO_ERROR", e);
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public long readLong() throws JMSException {
        this.backupState();
        try {
            return this.getInput().readLong();
        }
        catch (EOFException e) {
            this.restoreState();
            throw new MessageEOFException("End of body reached");
        }
        catch (IOException e) {
            this.restoreState();
            throw new FFMQException("Cannot read message body", "IO_ERROR", e);
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public short readShort() throws JMSException {
        this.backupState();
        try {
            return this.getInput().readShort();
        }
        catch (EOFException e) {
            this.restoreState();
            throw new MessageEOFException("End of body reached");
        }
        catch (IOException e) {
            this.restoreState();
            throw new FFMQException("Cannot read message body", "IO_ERROR", e);
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public String readUTF() throws JMSException {
        this.backupState();
        try {
            return this.getInput().readUTF();
        }
        catch (EOFException e) {
            this.restoreState();
            throw new MessageEOFException("End of body reached");
        }
        catch (IOException e) {
            this.restoreState();
            throw new FFMQException("Cannot read message body", "IO_ERROR", e);
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.backupState();
        try {
            return this.getInput().readUnsignedByte();
        }
        catch (EOFException e) {
            this.restoreState();
            throw new MessageEOFException("End of body reached");
        }
        catch (IOException e) {
            this.restoreState();
            throw new FFMQException("Cannot read message body", "IO_ERROR", e);
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.backupState();
        try {
            return this.getInput().readUnsignedShort();
        }
        catch (EOFException e) {
            this.restoreState();
            throw new MessageEOFException("End of body reached");
        }
        catch (IOException e) {
            this.restoreState();
            throw new FFMQException("Cannot read message body", "IO_ERROR", e);
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public void reset() {
        this.assertDeserializationLevel(3);
        this.tidyUp();
        this.bodyIsReadOnly = true;
    }

    public void writeBoolean(boolean value) throws JMSException {
        try {
            this.getOutput().writeBoolean(value);
        }
        catch (IOException e) {
            throw new FFMQException("Cannot write message body", "IO_ERROR", e);
        }
    }

    public void writeByte(byte value) throws JMSException {
        try {
            this.getOutput().writeByte(value);
        }
        catch (IOException e) {
            throw new FFMQException("Cannot write message body", "IO_ERROR", e);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        try {
            this.getOutput().write(value);
        }
        catch (IOException e) {
            throw new FFMQException("Cannot write message body", "IO_ERROR", e);
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        try {
            this.getOutput().write(value, offset, length);
        }
        catch (IOException e) {
            throw new FFMQException("Cannot write message body", "IO_ERROR", e);
        }
    }

    public void writeChar(char value) throws JMSException {
        try {
            this.getOutput().writeChar(value);
        }
        catch (IOException e) {
            throw new FFMQException("Cannot write message body", "IO_ERROR", e);
        }
    }

    public void writeDouble(double value) throws JMSException {
        try {
            this.getOutput().writeDouble(value);
        }
        catch (IOException e) {
            throw new FFMQException("Cannot write message body", "IO_ERROR", e);
        }
    }

    public void writeFloat(float value) throws JMSException {
        try {
            this.getOutput().writeFloat(value);
        }
        catch (IOException e) {
            throw new FFMQException("Cannot write message body", "IO_ERROR", e);
        }
    }

    public void writeInt(int value) throws JMSException {
        try {
            this.getOutput().writeInt(value);
        }
        catch (IOException e) {
            throw new FFMQException("Cannot write message body", "IO_ERROR", e);
        }
    }

    public void writeLong(long value) throws JMSException {
        try {
            this.getOutput().writeLong(value);
        }
        catch (IOException e) {
            throw new FFMQException("Cannot write message body", "IO_ERROR", e);
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeUTF((String)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException("Unsupported property value type : " + value.getClass().getName());
        }
    }

    public void writeShort(short value) throws JMSException {
        try {
            this.getOutput().writeShort(value);
        }
        catch (IOException e) {
            throw new FFMQException("Cannot write message body", "IO_ERROR", e);
        }
    }

    public void writeUTF(String value) throws JMSException {
        try {
            this.getOutput().writeUTF(value);
        }
        catch (IOException e) {
            throw new FFMQException("Cannot write message body", "IO_ERROR", e);
        }
    }

    @Override
    public AbstractMessage copy() {
        BytesMessageImpl clone = new BytesMessageImpl();
        this.copyCommonFields(clone);
        this.tidyUp();
        clone.body = this.body;
        return clone;
    }
}

