/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.destination;

import javax.jms.JMSException;
import javax.jms.TemporaryQueue;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.connection.AbstractConnection;
import net.timewalker.ffmq4.common.destination.QueueRef;
import net.timewalker.ffmq4.common.destination.TemporaryDestination;

public final class TemporaryQueueRef
extends QueueRef
implements TemporaryQueue,
TemporaryDestination {
    private static final long serialVersionUID = 1L;
    private transient AbstractConnection connection;

    public TemporaryQueueRef(AbstractConnection connection, String queueName) {
        super(queueName);
        this.connection = connection;
    }

    public void delete() throws JMSException {
        if (this.connection == null) {
            throw new FFMQException("Temporary queue already deleted", "QUEUE_DOES_NOT_EXIST");
        }
        this.connection.deleteTemporaryQueue(this.name);
        this.connection = null;
    }

    @Override
    public String toString() {
        return super.toString() + "[T]";
    }
}

