/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.cluster.resolver;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.NamingException;
import net.timewalker.ffmq4.cluster.resolver.DestinationResolver;
import net.timewalker.ffmq4.management.destination.DestinationReferenceDescriptor;
import net.timewalker.ffmq4.management.peer.PeerDescriptor;
import net.timewalker.ffmq4.utils.JNDITools;

public class JndiDestinationResolver
implements DestinationResolver {
    @Override
    public Destination getDestination(PeerDescriptor peer, DestinationReferenceDescriptor destinationReference, Session session) throws JMSException {
        try {
            Context jndiContext = JNDITools.getContext(peer.getJdniInitialContextFactoryName(), peer.getProviderURL(), null);
            return (Destination)jndiContext.lookup(destinationReference.getDestinationName());
        }
        catch (NamingException e) {
            throw new JMSException("Cannot resolve destination in JNDI : " + e.toString());
        }
    }
}

