/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.ThucydidesReporter;
import net.thucydides.core.reports.adaptors.TestOutcomeAdaptor;
import net.thucydides.core.reports.html.HtmlAcceptanceTestReporter;
import net.thucydides.core.reports.json.JSONTestOutcomeReporter;
import net.thucydides.core.reports.xml.XMLTestOutcomeReporter;

public class TestOutcomeAdaptorReporter
extends ThucydidesReporter {
    private List<TestOutcomeAdaptor> adaptors = Lists.newArrayList();
    private final Optional<File> NO_SOURCE_FILE = Optional.absent();

    public void generateReports() throws IOException {
        this.generateReports(this.NO_SOURCE_FILE);
    }

    public void generateReportsFrom(File sourceDirectory) throws IOException {
        this.generateReports((Optional<File>)Optional.fromNullable((Object)sourceDirectory));
    }

    public void generateReports(Optional<File> sourceDirectory) throws IOException {
        this.setupOutputDirectoryIfRequired();
        for (TestOutcomeAdaptor adaptor : this.adaptors) {
            List<TestOutcome> outcomes = sourceDirectory.isPresent() ? adaptor.loadOutcomesFrom((File)sourceDirectory.get()) : adaptor.loadOutcomes();
            this.generateReportsFor(outcomes);
        }
    }

    private void setupOutputDirectoryIfRequired() {
        if (this.getOutputDirectory() != null) {
            this.getOutputDirectory().mkdirs();
        }
    }

    private void generateReportsFor(List<TestOutcome> outcomes) throws IOException {
        AcceptanceTestReporter xmlTestOutcomeReporter = this.getXMLReporter();
        AcceptanceTestReporter htmlAcceptanceTestReporter = this.getHTMLReporter();
        AcceptanceTestReporter jsonReporter = this.getJsonReporter();
        TestOutcomes allOutcomes = TestOutcomes.of(outcomes);
        for (TestOutcome testOutcome : allOutcomes.getOutcomes()) {
            xmlTestOutcomeReporter.generateReportFor(testOutcome, allOutcomes);
            jsonReporter.generateReportFor(testOutcome, allOutcomes);
            htmlAcceptanceTestReporter.generateReportFor(testOutcome, allOutcomes);
        }
    }

    private AcceptanceTestReporter getXMLReporter() {
        XMLTestOutcomeReporter reporter = new XMLTestOutcomeReporter();
        reporter.setOutputDirectory(this.getOutputDirectory());
        return reporter;
    }

    private AcceptanceTestReporter getJsonReporter() {
        JSONTestOutcomeReporter reporter = new JSONTestOutcomeReporter();
        reporter.setOutputDirectory(this.getOutputDirectory());
        return reporter;
    }

    private AcceptanceTestReporter getHTMLReporter() {
        HtmlAcceptanceTestReporter reporter = new HtmlAcceptanceTestReporter();
        reporter.setOutputDirectory(this.getOutputDirectory());
        return reporter;
    }

    public void registerAdaptor(TestOutcomeAdaptor adaptor) {
        this.adaptors.add(adaptor);
    }
}

