/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ecmascript;

import java.util.Objects;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.lang.ParserOptions;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.properties.EnumeratedProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class EcmascriptParserOptions
extends ParserOptions {
    private static final String[] VERSION_LABELS = new String[]{Version.VERSION_DEFAULT.getLabel(), Version.VERSION_1_0.getLabel(), Version.VERSION_1_1.getLabel(), Version.VERSION_1_2.getLabel(), Version.VERSION_1_3.getLabel(), Version.VERSION_1_4.getLabel(), Version.VERSION_1_5.getLabel(), Version.VERSION_1_6.getLabel(), Version.VERSION_1_7.getLabel(), Version.VERSION_1_8.getLabel()};
    public static final BooleanProperty RECORDING_COMMENTS_DESCRIPTOR = new BooleanProperty("recordingComments", "Specifies that comments are produced in the AST.", Boolean.TRUE.booleanValue(), 3.0f);
    public static final BooleanProperty RECORDING_LOCAL_JSDOC_COMMENTS_DESCRIPTOR = new BooleanProperty("recordingLocalJsDocComments", "Specifies that JsDoc comments are produced in the AST.", Boolean.TRUE.booleanValue(), 4.0f);
    public static final EnumeratedProperty<Version> RHINO_LANGUAGE_VERSION = new EnumeratedProperty("rhinoLanguageVersion", "Specifies the Rhino Language Version to use for parsing.  Defaults to Rhino default.", VERSION_LABELS, (Object[])Version.values(), 0, Version.class, 5.0f);
    private boolean recordingComments;
    private boolean recordingLocalJsDocComments;
    private Version rhinoLanguageVersion;

    public EcmascriptParserOptions() {
        this.recordingComments = (Boolean)RECORDING_COMMENTS_DESCRIPTOR.defaultValue();
        this.recordingLocalJsDocComments = (Boolean)RECORDING_LOCAL_JSDOC_COMMENTS_DESCRIPTOR.defaultValue();
        this.rhinoLanguageVersion = (Version)((Object)RHINO_LANGUAGE_VERSION.defaultValue());
    }

    public EcmascriptParserOptions(Rule rule) {
        this.recordingComments = (Boolean)rule.getProperty((PropertyDescriptor)RECORDING_COMMENTS_DESCRIPTOR);
        this.recordingLocalJsDocComments = (Boolean)rule.getProperty((PropertyDescriptor)RECORDING_LOCAL_JSDOC_COMMENTS_DESCRIPTOR);
        this.rhinoLanguageVersion = (Version)((Object)rule.getProperty(RHINO_LANGUAGE_VERSION));
    }

    public boolean isRecordingComments() {
        return this.recordingComments;
    }

    public void setRecordingComments(boolean recordingComments) {
        this.recordingComments = recordingComments;
    }

    public boolean isRecordingLocalJsDocComments() {
        return this.recordingLocalJsDocComments;
    }

    public void setRecordingLocalJsDocComments(boolean recordingLocalJsDocComments) {
        this.recordingLocalJsDocComments = recordingLocalJsDocComments;
    }

    public Version getRhinoLanguageVersion() {
        return this.rhinoLanguageVersion;
    }

    public void setRhinoLanguageVersion(Version rhinoLanguageVersion) {
        this.rhinoLanguageVersion = rhinoLanguageVersion;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.recordingComments ? 1231 : 1237);
        result = 31 * result + (this.recordingLocalJsDocComments ? 1231 : 1237);
        result = 31 * result + (this.rhinoLanguageVersion == null ? 0 : this.rhinoLanguageVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EcmascriptParserOptions that = (EcmascriptParserOptions)((Object)obj);
        return Objects.equals(this.suppressMarker, that.suppressMarker) && this.recordingComments == that.recordingComments && this.recordingLocalJsDocComments == that.recordingLocalJsDocComments && this.rhinoLanguageVersion == that.rhinoLanguageVersion;
    }

    public static enum Version {
        VERSION_DEFAULT("default", 0),
        VERSION_1_0("1.0", 100),
        VERSION_1_1("1.1", 110),
        VERSION_1_2("1.2", 120),
        VERSION_1_3("1.3", 130),
        VERSION_1_4("1.4", 140),
        VERSION_1_5("1.5", 150),
        VERSION_1_6("1.6", 160),
        VERSION_1_7("1.7", 170),
        VERSION_1_8("1.8", 180);

        private final String name;
        private final int version;

        private Version(String name, int version) {
            this.name = name;
            this.version = version;
        }

        public String getLabel() {
            return this.name;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

