/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.deploy;

import java.io.File;
import java.util.Properties;
import net.sf.jnati.NativeCodeException;
import net.sf.jnati.deploy.LibraryLoader;
import net.sf.jnati.deploy.NativeArtefactLocator;
import net.sf.jnati.deploy.artefact.Artefact;
import net.sf.jnati.deploy.artefact.ArtefactFile;
import org.apache.log4j.Logger;

public class NativeLibraryLoader {
    private static final Logger LOG = Logger.getLogger(NativeLibraryLoader.class);

    public static Artefact loadLibrary(String id, String version) throws NativeCodeException {
        return NativeLibraryLoader.loadLibrary(id, version, null);
    }

    public static Artefact loadLibrary(String id, String version, Properties configuration) throws NativeCodeException {
        return NativeLibraryLoader.loadLibrary(id, version, configuration, null);
    }

    public static Artefact loadLibrary(String id, String version, Properties configuration, LibraryLoader loader) throws NativeCodeException {
        NativeArtefactLocator locator = new NativeArtefactLocator();
        Artefact artefact = locator.getArtefact(id, version, configuration);
        int redeploy = 0;
        Artefact current = artefact;
        while (redeploy < 1000) {
            try {
                if (current == null) continue;
                NativeLibraryLoader.loadLibrary(current, loader);
                return current;
            }
            catch (UnsatisfiedLinkError e) {
                if (e.getMessage().endsWith("already loaded in another classloader")) {
                    LOG.info((Object)("Multideploy enabled: " + artefact.isMultideployEnabled()));
                    if (artefact.isMultideployEnabled()) {
                        if (artefact.getMaxMultideployCount() > 0 && redeploy >= artefact.getMaxMultideployCount()) {
                            throw new NativeCodeException("Unable to load native code - max deploy count reached (" + redeploy + ")", (Throwable)e);
                        }
                        ++redeploy;
                        try {
                            current = locator.redeployArtefact(artefact, redeploy);
                        }
                        catch (Exception ex) {}
                        continue;
                    }
                }
                throw e;
            }
        }
        throw new NativeCodeException("Unable to load native code - deploy count limit reached");
    }

    private static void loadLibrary(Artefact artefact, LibraryLoader loader) throws NativeCodeException {
        File root = artefact.getPath();
        for (ArtefactFile resource : artefact.getFileList()) {
            if (!resource.isLibrary()) continue;
            File file = new File(root, resource.getPath());
            String path = file.getAbsolutePath();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading library: " + path));
            }
            if (loader == null) {
                System.load(path);
                continue;
            }
            loader.loadLibrary(path);
        }
    }
}

