/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.image.loader;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.XMLNamespaceEnabledImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageConverter;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.BarcodeException;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.BarcodeUtil;
import org.krysalis.barcode4j.image.loader.ImageBarcode;
import org.krysalis.barcode4j.tools.ConfigurationUtil;
import org.krysalis.barcode4j.tools.PageInfo;
import org.krysalis.barcode4j.tools.VariableUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ImageConverterBarcodeXML2Barcode
extends AbstractImageConverter {
    private static final XMLNamespaceEnabledImageFlavor BARCODE_XML_FLAVOR = new XMLNamespaceEnabledImageFlavor(ImageFlavor.XML_DOM, "http://barcode4j.krysalis.org/ns");

    public Image convert(Image src, Map hints) throws ImageException, IOException {
        this.checkSourceFlavor(src);
        ImageXMLDOM barcodeXML = (ImageXMLDOM)src;
        Document doc = barcodeXML.getDocument();
        try {
            Configuration cfg = ConfigurationUtil.buildConfiguration((Node)doc);
            String msg = ConfigurationUtil.getMessage((Configuration)cfg);
            BarcodeGenerator bargen = BarcodeUtil.getInstance().createBarcodeGenerator(cfg);
            PageInfo pageInfo = PageInfo.fromProcessingHints((Map)hints);
            String expandedMsg = VariableUtil.getExpandedMessage((PageInfo)pageInfo, (String)msg);
            BarcodeDimension bardim = bargen.calcDimensions(expandedMsg);
            ImageBarcode imageBarcode = new ImageBarcode(src.getInfo(), cfg, bardim);
            return imageBarcode;
        }
        catch (ConfigurationException ce) {
            throw new ImageException("Error building configuration object for barcode", (Throwable)ce);
        }
        catch (BarcodeException be) {
            throw new ImageException("Error determining dimensions for barcode", (Throwable)be);
        }
    }

    public ImageFlavor getSourceFlavor() {
        return BARCODE_XML_FLAVOR;
    }

    public ImageFlavor getTargetFlavor() {
        return ImageBarcode.BARCODE_IMAGE_FLAVOR;
    }
}

