/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter.jsoup;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.revelc.code.formatter.AbstractCacheableFormatter;
import net.revelc.code.formatter.ConfigurationSource;
import net.revelc.code.formatter.Formatter;
import net.revelc.code.formatter.LineEnding;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;
import org.jsoup.parser.Parser;

public abstract class JsoupBasedFormatter
extends AbstractCacheableFormatter
implements Formatter {
    private Document.OutputSettings formatter;

    @Override
    public void init(Map<String, String> options, ConfigurationSource cfg) {
        super.initCfg(cfg);
        this.formatter = new Document.OutputSettings();
        this.formatter.charset(Charset.forName(options.getOrDefault("charset", StandardCharsets.UTF_8.name())));
        this.formatter.escapeMode(Entities.EscapeMode.valueOf((String)options.getOrDefault("escapeMode", Entities.EscapeMode.xhtml.name())));
        this.formatter.indentAmount(Integer.parseInt(options.getOrDefault("indentAmount", "4")));
        this.formatter.outline(Boolean.parseBoolean(options.getOrDefault("outlineMode", Boolean.TRUE.toString())));
        this.formatter.prettyPrint(Boolean.parseBoolean(options.getOrDefault("pretty", Boolean.TRUE.toString())));
        this.formatter.syntax(Document.OutputSettings.Syntax.valueOf((String)options.getOrDefault("syntax", Document.OutputSettings.Syntax.html.name())));
    }

    @Override
    public String doFormat(String code, LineEnding ending) {
        Document document;
        switch (this.formatter.syntax()) {
            case html: {
                document = Jsoup.parse((String)code, (String)"", (Parser)Parser.htmlParser());
                break;
            }
            case xml: {
                document = Jsoup.parse((String)code, (String)"", (Parser)Parser.xmlParser());
                break;
            }
            default: {
                throw new IllegalArgumentException(this.formatter.syntax() + " is not allowed as syntax");
            }
        }
        document.outputSettings(this.formatter);
        String formattedCode = document.outerHtml();
        if (code.equals(formattedCode)) {
            return null;
        }
        return formattedCode;
    }

    @Override
    public boolean isInitialized() {
        return this.formatter != null;
    }
}

