/*
 * Decompiled with CFR 0.152.
 */
package net.objecthunter.exp4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.objecthunter.exp4j.ValidationResult;
import net.objecthunter.exp4j.tokenizer.FunctionToken;
import net.objecthunter.exp4j.tokenizer.NumberToken;
import net.objecthunter.exp4j.tokenizer.OperatorToken;
import net.objecthunter.exp4j.tokenizer.Token;
import net.objecthunter.exp4j.tokenizer.VariableToken;

public class Expression {
    private final Token[] tokens;
    private final Map<String, Double> variables;
    private final Set<String> userFunctionNames;

    Expression(Token[] tokens) {
        this.tokens = tokens;
        this.variables = new HashMap<String, Double>(4);
        this.userFunctionNames = Collections.emptySet();
    }

    Expression(Token[] tokens, Set<String> userFunctionNames) {
        this.tokens = tokens;
        this.variables = new HashMap<String, Double>(4);
        this.userFunctionNames = userFunctionNames;
    }

    public Expression setVariable(String name, double value) {
        this.checkVariableName(name);
        this.variables.put(name, value);
        return this;
    }

    private void checkVariableName(String name) {
        if (this.userFunctionNames.contains(name)) {
            throw new IllegalArgumentException("The setVariable name '" + name + "' is invalid. Since there exists a function with the same name");
        }
    }

    public Expression setVariables(Map<String, Double> variables) {
        for (Map.Entry<String, Double> v : variables.entrySet()) {
            this.setVariable(v.getKey(), v.getValue());
        }
        return this;
    }

    public ValidationResult validate() {
        ArrayList<String> errors = new ArrayList<String>(0);
        for (Token t : this.tokens) {
            String var;
            if (t.getType() != 6 || this.variables.containsKey(var = ((VariableToken)t).getName())) continue;
            errors.add("The setVariable '" + var + "' has not been set");
        }
        return errors.size() == 0 ? ValidationResult.SUCCESS : new ValidationResult(false, errors);
    }

    public double evaluate() {
        Stack<Double> output = new Stack<Double>();
        for (int i = 0; i < this.tokens.length; ++i) {
            Token t = this.tokens[i];
            if (t.getType() == 1) {
                output.push(((NumberToken)t).getValue());
                continue;
            }
            if (t.getType() == 6) {
                String name = ((VariableToken)t).getName();
                Double value = this.variables.get(name);
                if (value == null) {
                    throw new IllegalArgumentException("No value has been set for the setVariable '" + name + "'.");
                }
                output.push(value);
                continue;
            }
            if (t.getType() == 2) {
                OperatorToken op = (OperatorToken)t;
                if (output.size() < op.getOperator().getNumOperands()) {
                    throw new IllegalArgumentException("Invalid number of operands available");
                }
                if (op.getOperator().getNumOperands() == 2) {
                    double rightArg = (Double)output.pop();
                    double leftArg = (Double)output.pop();
                    output.push(op.getOperator().apply(leftArg, rightArg));
                    continue;
                }
                if (op.getOperator().getNumOperands() != 1) continue;
                double arg = (Double)output.pop();
                output.push(op.getOperator().apply(arg));
                continue;
            }
            if (t.getType() != 3) continue;
            FunctionToken func = (FunctionToken)t;
            if (output.size() < func.getFunction().getNumArguments()) {
                throw new IllegalArgumentException("Invalid number of arguments available");
            }
            double[] args = new double[func.getFunction().getNumArguments()];
            for (int j = 0; j < func.getFunction().getNumArguments(); ++j) {
                args[j] = (Double)output.pop();
            }
            output.push(func.getFunction().apply(this.reverseInPlace(args)));
        }
        if (output.size() > 1) {
            throw new IllegalArgumentException("Invalid number of items on the output queue. Might be caused by an invalid number of arguments for a function.");
        }
        return (Double)output.pop();
    }

    private double[] reverseInPlace(double[] args) {
        int len = args.length;
        for (int i = 0; i < len / 2; ++i) {
            double tmp = args[i];
            args[i] = args[len - i - 1];
            args[len - i - 1] = tmp;
        }
        return args;
    }
}

