/*
 * #%L
 * Cantharella :: Service
 * $Id: ExtractionNormalizer.java 269 2014-05-07 08:14:00Z echatellier $
 * $HeadURL: https://svn.codelutin.com/cantharella/tags/cantharella-1.2/cantharella.service/src/main/java/nc/ird/cantharella/service/utils/normalizers/ExtractionNormalizer.java $
 * %%
 * Copyright (C) 2009 - 2012 IRD (Institut de Recherche pour le Developpement) and by respective authors (see below)
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package nc.ird.cantharella.service.utils.normalizers;

import nc.ird.cantharella.data.model.Extraction;
import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalizer;
import nc.ird.cantharella.utils.AssertTools;

/**
 * Extraction normalizer
 * 
 * @author Adrien Cheype
 */
public final class ExtractionNormalizer extends Normalizer<Extraction> {

    /** {@inheritDoc} */
    @Override
    protected Extraction normalize(Extraction extraction) {
        AssertTools.assertNotNull(extraction);
        // Unique fields
        extraction.setRef(Normalizer.normalize(UniqueFieldNormalizer.class, extraction.getRef()));
        for (Extrait curExtrait : extraction.getExtraits()) {
            curExtrait.setRef(Normalizer.normalize(UniqueFieldNormalizer.class, curExtrait.getRef()));
        }
        return extraction;
    }

}
