package io.undertow.websockets.jsr;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import java.lang.reflect.Method;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import javax.websocket.server.PathParam;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-02-22T06:28:31-0300")
public class JsrWebSocketLogger_$logger extends DelegatingBasicLogger implements JsrWebSocketLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JsrWebSocketLogger_$logger.class.getName();
    public JsrWebSocketLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void endpointCreationFailed(final Exception cause) {
        super.log.logf(FQCN, ERROR, cause, endpointCreationFailed$str());
    }
    private static final String endpointCreationFailed = "UT026001: Unable to instantiate endpoint";
    protected String endpointCreationFailed$str() {
        return endpointCreationFailed;
    }
    @Override
    public final void couldNotInitializeConfiguration(final Class<?> clazz, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, couldNotInitializeConfiguration$str(), clazz);
    }
    private static final String couldNotInitializeConfiguration = "UT026002: Unable to instantiate server configuration %s";
    protected String couldNotInitializeConfiguration$str() {
        return couldNotInitializeConfiguration;
    }
    @Override
    public final void addingAnnotatedServerEndpoint(final Class<?> endpoint, final String value) {
        super.log.logf(FQCN, INFO, null, addingAnnotatedServerEndpoint$str(), endpoint, value);
    }
    private static final String addingAnnotatedServerEndpoint = "UT026003: Adding annotated server endpoint %s for path %s";
    protected String addingAnnotatedServerEndpoint$str() {
        return addingAnnotatedServerEndpoint;
    }
    @Override
    public final void addingAnnotatedClientEndpoint(final Class<?> endpoint) {
        super.log.logf(FQCN, INFO, null, addingAnnotatedClientEndpoint$str(), endpoint);
    }
    private static final String addingAnnotatedClientEndpoint = "UT026004: Adding annotated client endpoint %s";
    protected String addingAnnotatedClientEndpoint$str() {
        return addingAnnotatedClientEndpoint;
    }
    @Override
    public final void addingProgramaticEndpoint(final Class<?> endpointClass, final String path) {
        super.log.logf(FQCN, INFO, null, addingProgramaticEndpoint$str(), endpointClass, path);
    }
    private static final String addingProgramaticEndpoint = "UT026005: Adding programmatic server endpoint %s for path %s";
    protected String addingProgramaticEndpoint$str() {
        return addingProgramaticEndpoint;
    }
    @Override
    public final void exceptionInWebSocketMethod(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, exceptionInWebSocketMethod$str());
    }
    private static final String exceptionInWebSocketMethod = "UT026006: Exception running web socket method";
    protected String exceptionInWebSocketMethod$str() {
        return exceptionInWebSocketMethod;
    }
    @Override
    public final void pathTemplateNotFound(final Class<?> endpointClass, final PathParam param, final Method method, final java.util.Set<String> paths) {
        super.log.logf(FQCN, WARN, null, pathTemplateNotFound$str(), endpointClass, param, method, paths);
    }
    private static final String pathTemplateNotFound = "UT026007: On Endpoint class %s path param %s on method %s does not reference a valid parameter, valid parameters are %s.";
    protected String pathTemplateNotFound$str() {
        return pathTemplateNotFound;
    }
    @Override
    public final void couldNotCloseOnUndeploy(final Exception e) {
        super.log.logf(FQCN, ERROR, e, couldNotCloseOnUndeploy$str());
    }
    private static final String couldNotCloseOnUndeploy = "UT026008: Could not close endpoint on undeploy.";
    protected String couldNotCloseOnUndeploy$str() {
        return couldNotCloseOnUndeploy;
    }
    @Override
    public final void xnioWorkerWasNull() {
        super.log.logf(FQCN, WARN, null, xnioWorkerWasNull$str());
    }
    private static final String xnioWorkerWasNull = "UT026009: XNIO worker was not set on WebSocketDeploymentInfo, the default worker will be used";
    protected String xnioWorkerWasNull$str() {
        return xnioWorkerWasNull;
    }
    @Override
    public final void bufferPoolWasNull() {
        super.log.logf(FQCN, WARN, null, bufferPoolWasNull$str());
    }
    private static final String bufferPoolWasNull = "UT026010: Buffer pool was not set on WebSocketDeploymentInfo, the default pool will be used";
    protected String bufferPoolWasNull$str() {
        return bufferPoolWasNull;
    }
    private static final String xnioWorkerWasNullAndNoDefault = "UT026011: XNIO worker was not set on WebSocketDeploymentInfo, and there is no default to use";
    protected String xnioWorkerWasNullAndNoDefault$str() {
        return xnioWorkerWasNullAndNoDefault;
    }
    @Override
    public final IllegalArgumentException xnioWorkerWasNullAndNoDefault() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), xnioWorkerWasNullAndNoDefault$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String bufferPoolWasNullAndNoDefault = "UT026012: Buffer pool was not set on WebSocketDeploymentInfo, and there is no default to use";
    protected String bufferPoolWasNullAndNoDefault$str() {
        return bufferPoolWasNullAndNoDefault;
    }
    @Override
    public final IllegalArgumentException bufferPoolWasNullAndNoDefault() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), bufferPoolWasNullAndNoDefault$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
