/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinatraServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SinatraServerCodegen.class);
    protected String gemName;
    protected String moduleName;
    protected String gemVersion = "1.0.0";
    protected String libFolder = "lib";

    public SinatraServerCodegen() {
        this.apiPackage = "lib";
        this.outputFolder = "generated-code" + File.separator + "sinatra";
        this.modelTemplateFiles.clear();
        this.apiTemplateFiles.put("api.mustache", ".rb");
        this.templateDir = "sinatra";
        this.embeddedTemplateDir = "sinatra";
        this.typeMapping.clear();
        this.languageSpecificPrimitives.clear();
        this.setReservedWordsLowerCase(Arrays.asList("__FILE__", "and", "def", "end", "in", "or", "self", "unless", "__LINE__", "begin", "defined?", "ensure", "module", "redo", "super", "until", "BEGIN", "break", "do", "false", "next", "rescue", "then", "when", "END", "case", "else", "for", "nil", "retry", "true", "while", "alias", "class", "elsif", "if", "not", "return", "undef", "yield"));
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("array");
        this.languageSpecificPrimitives.add("map");
        this.languageSpecificPrimitives.add("string");
        this.languageSpecificPrimitives.add("DateTime");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("Array", "array");
        this.typeMapping.put("String", "string");
        this.typeMapping.put("List", "array");
        this.typeMapping.put("map", "map");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("UUID", "string");
        this.cliOptions.clear();
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.setApiPackage("api");
        this.supportingFiles.add(new SupportingFile("my_app.mustache", "", "my_app.rb"));
        this.supportingFiles.add(new SupportingFile("Swaggering.rb", this.libFolder, "swaggering.rb"));
        this.supportingFiles.add(new SupportingFile("config.ru", "", "config.ru"));
        this.supportingFiles.add(new SupportingFile("Gemfile", "", "Gemfile"));
        this.supportingFiles.add(new SupportingFile("README.md", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("swagger.mustache", "", "swagger.yaml"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "sinatra";
    }

    @Override
    public String getHelp() {
        return "Generates a Sinatra server library.";
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage.replace("/", File.separator);
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        if (propertySchema instanceof ArraySchema) {
            Schema inner = ((ArraySchema)propertySchema).getItems();
            return String.format("%s[%s]", this.getSchemaType(propertySchema), this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof MapSchema && SinatraServerCodegen.hasSchemaProperties(propertySchema)) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            return String.format("%s[string, %s]", this.getSchemaType(propertySchema), this.getTypeDeclaration(inner));
        }
        return super.getTypeDeclaration(propertySchema);
    }

    @Override
    public String getSchemaType(Schema propertySchema) {
        String schemaType = super.getSchemaType(propertySchema);
        String type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = schemaType;
        }
        if (type == null) {
            return null;
        }
        return type;
    }

    @Override
    public String toDefaultValue(Schema p) {
        return "null";
    }

    @Override
    public String toVarName(String name) {
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            name = name.toLowerCase();
        }
        if (this.isReservedWord(name = SinatraServerCodegen.underscore(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.isReservedWord(name)) {
            LOGGER.warn(name + " (reserved word) cannot be used as model filename. Renamed to " + SinatraServerCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        return SinatraServerCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        if (this.isReservedWord(name)) {
            LOGGER.warn(name + " (reserved word) cannot be used as model filename. Renamed to " + SinatraServerCodegen.underscore("model_" + name));
            name = "model_" + name;
        }
        return SinatraServerCodegen.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return SinatraServerCodegen.underscore(name) + "_api";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return SinatraServerCodegen.camelize(name) + "Api";
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.isReservedWord(operationId)) {
            String newOperationId = SinatraServerCodegen.underscore("call_" + operationId);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        return SinatraServerCodegen.underscore(operationId);
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        OpenAPI openAPI = (OpenAPI)objs.get("openapi");
        if (openAPI != null) {
            try {
                objs.put("swagger-yaml", Yaml.mapper().writeValueAsString((Object)openAPI));
            }
            catch (JsonProcessingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("=end", "=_end").replace("=begin", "=_begin");
    }
}

