/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;
import java.util.Map;

public class CliOption {
    private final String opt;
    private String description;
    private String type;
    private String defaultValue;
    private Map<String, String> enumValues;

    public CliOption(String opt, String description) {
        this(opt, description, "string");
    }

    public CliOption(String opt, String description, String type) {
        this.opt = opt;
        this.description = description;
        this.type = type;
    }

    public String getOpt() {
        return this.opt;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public CliOption defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public CliOption addEnum(String value, String description) {
        if (this.enumValues == null) {
            this.enumValues = new LinkedHashMap<String, String>();
        }
        if (!this.enumValues.containsKey(value)) {
            this.enumValues.put(value, description);
        }
        return this;
    }

    public Map<String, String> getEnum() {
        return this.enumValues;
    }

    public void setEnum(Map<String, String> enumValues) {
        this.enumValues = enumValues;
    }

    public static CliOption newBoolean(String opt, String description) {
        return new CliOption(opt, description, "boolean").defaultValue(Boolean.FALSE.toString());
    }

    public static CliOption newString(String opt, String description) {
        return new CliOption(opt, description, "string");
    }

    @JsonIgnore
    public String getOptionHelp() {
        StringBuilder sb = new StringBuilder(this.description);
        if (this.defaultValue != null) {
            sb.append(" (Default: ").append(this.defaultValue).append(")");
        }
        if (this.enumValues != null) {
            for (Map.Entry<String, String> entry : this.enumValues.entrySet()) {
                sb.append("\n    ").append(entry.getKey()).append(" - ").append(entry.getValue());
            }
        }
        return sb.toString();
    }
}

