/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.spring;

import io.smallrye.openapi.spring.SpringConstants;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

class SpringSupport {
    private SpringSupport() {
    }

    static Set<PathItem.HttpMethod> getHttpMethods(MethodInfo methodInfo) {
        AnnotationInstance requestMappingAnnotation;
        AnnotationValue methodValue;
        LinkedHashSet<PathItem.HttpMethod> methods = new LinkedHashSet<PathItem.HttpMethod>();
        for (DotName validMethodAnnotations : SpringConstants.HTTP_METHODS) {
            if (!methodInfo.hasAnnotation(validMethodAnnotations)) continue;
            String toHttpMethod = SpringSupport.toHttpMethod(validMethodAnnotations);
            methods.add(PathItem.HttpMethod.valueOf((String)toHttpMethod));
        }
        if (methodInfo.hasAnnotation(SpringConstants.REQUEST_MAPPING) && (methodValue = (requestMappingAnnotation = methodInfo.annotation(SpringConstants.REQUEST_MAPPING)).value("method")) != null) {
            String[] enumArray;
            for (String enumValue : enumArray = methodValue.asEnumArray()) {
                if (enumValue == null) continue;
                methods.add(PathItem.HttpMethod.valueOf((String)enumValue.toUpperCase()));
            }
        }
        return methods;
    }

    private static String toHttpMethod(DotName dotname) {
        String className = dotname.withoutPackagePrefix();
        className = className.replace("Mapping", "");
        return className.toUpperCase();
    }
}

