/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.KotlinUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import io.smallrye.openapi.runtime.util.UtilLogging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;

public final class Annotations {
    private static final String VALUE = "value";
    private static final Map<PrimitiveType.Primitive, AnnotationValue.Kind> PRIMITIVES;
    private static final DotName CLASS_NAME;
    private static final Type ENUM_TYPE;
    private static final Type ANNOTATION_TYPE;
    private final AnnotationScannerContext context;
    private final Collection<DotName> excludedPackages;

    public Annotations(AnnotationScannerContext context) {
        this.context = context;
        this.excludedPackages = Names.componentize(context.getConfig().getScanCompositionExcludePackages()).values();
    }

    private static Collection<AnnotationInstance> getDeclaredAnnotations(AnnotationTarget target) {
        if (target.kind() == AnnotationTarget.Kind.FIELD) {
            return Annotations.declaredFieldAnnotations(target.asField());
        }
        return target.declaredAnnotations();
    }

    private static List<AnnotationInstance> declaredFieldAnnotations(FieldInfo field) {
        List fieldAnnotations = field.declaredAnnotations();
        List<AnnotationInstance> propertyAnnotations = KotlinUtil.getPropertyAnnotations(field);
        if (propertyAnnotations.isEmpty()) {
            return fieldAnnotations;
        }
        if (fieldAnnotations.isEmpty()) {
            return propertyAnnotations;
        }
        ArrayList<AnnotationInstance> results = new ArrayList<AnnotationInstance>(fieldAnnotations.size() + propertyAnnotations.size());
        results.addAll(fieldAnnotations);
        results.addAll(propertyAnnotations);
        return results;
    }

    private boolean composable(DotName annotation) {
        for (DotName pkg : this.excludedPackages) {
            if (!annotation.startsWith(pkg)) continue;
            return false;
        }
        return true;
    }

    private List<AnnotationInstance> getComposedAnnotation(Collection<AnnotationInstance> declaredAnnotations, DotName name, Set<DotName> scanned) {
        ArrayList<AnnotationInstance> results = new ArrayList<AnnotationInstance>();
        for (AnnotationInstance annotation : declaredAnnotations) {
            ClassInfo annotationClass;
            DotName annotationName;
            if (!annotation.runtimeVisible() || !this.composable(annotationName = annotation.name()) || (annotationClass = this.context.getAugmentedIndex().getClassByName(annotationName)) == null || scanned.contains(annotationClass.name())) continue;
            scanned.add(annotationClass.name());
            UtilLogging.logger.composedAnnotationSearch(name, annotationClass.name());
            results.addAll(this.getDeclaredAnnotation((AnnotationTarget)annotationClass, name, scanned));
        }
        return results;
    }

    private List<AnnotationInstance> getDeclaredAnnotation(AnnotationTarget target, DotName name, Set<DotName> scanned) {
        if (target == null) {
            return Collections.emptyList();
        }
        Collection<AnnotationInstance> declaredAnnotations = Annotations.getDeclaredAnnotations(target);
        if (declaredAnnotations.isEmpty()) {
            return Collections.emptyList();
        }
        AnnotationInstance direct = declaredAnnotations.stream().filter(a -> name.equals((Object)a.name())).findFirst().orElse(null);
        List<AnnotationInstance> composed = this.getComposedAnnotation(declaredAnnotations, name, scanned);
        ArrayList<AnnotationInstance> results = new ArrayList<AnnotationInstance>((direct != null ? 1 : 0) + composed.size());
        if (direct != null) {
            results.add(direct);
        }
        results.addAll(composed);
        return results;
    }

    private List<AnnotationInstance> getDeclaredAnnotation(AnnotationTarget target, DotName name) {
        return this.getDeclaredAnnotation(target, name, new HashSet<DotName>());
    }

    public <T> T value(AnnotationInstance annotation) {
        return annotation != null ? (T)this.value(annotation, VALUE) : null;
    }

    private AnnotationValue.Kind valueKind(AnnotationInstance annotation, AnnotationValue value) {
        boolean isArray = AnnotationValue.Kind.ARRAY == value.kind();
        AnnotationValue.Kind kind = isArray ? value.componentKind() : value.kind();
        AugmentedIndexView index = this.context.getAugmentedIndex();
        ClassInfo annoClass = index.getClassByName(annotation.name());
        if (kind == AnnotationValue.Kind.UNKNOWN && annoClass != null) {
            MethodInfo valueMethod = annoClass.method(value.name(), new Type[0]);
            Type valueType = valueMethod.returnType().asArrayType().constituent();
            switch (valueType.kind()) {
                case PRIMITIVE: {
                    return PRIMITIVES.get(valueType.asPrimitiveType().primitive());
                }
                case CLASS: 
                case PARAMETERIZED_TYPE: {
                    if (valueType.name().equals((Object)DotName.STRING_NAME)) {
                        return AnnotationValue.Kind.STRING;
                    }
                    if (valueType.name().equals((Object)CLASS_NAME)) {
                        return AnnotationValue.Kind.CLASS;
                    }
                    if (TypeUtil.isA(this.context, valueType, ENUM_TYPE)) {
                        return AnnotationValue.Kind.ENUM;
                    }
                    if (!TypeUtil.isA(this.context, valueType, ANNOTATION_TYPE)) break;
                    return AnnotationValue.Kind.NESTED;
                }
            }
        }
        return kind;
    }

    public <T> T value(AnnotationInstance annotation, String name) {
        AnnotationValue value = annotation.value(name);
        if (value == null) {
            return null;
        }
        return this.value(annotation, value);
    }

    public <T> T value(AnnotationInstance annotation, AnnotationValue value) {
        AnnotationValue.Kind valueKind = this.valueKind(annotation, value);
        boolean isArray = AnnotationValue.Kind.ARRAY == value.kind();
        switch (valueKind) {
            case BOOLEAN: {
                return (T)(isArray ? value.asBooleanArray() : (boolean[])value.asBoolean());
            }
            case BYTE: {
                return (T)(isArray ? value.asByteArray() : (byte[])value.asByte());
            }
            case CHARACTER: {
                return (T)(isArray ? value.asCharArray() : (char[])Character.valueOf(value.asChar()));
            }
            case CLASS: {
                return (T)(isArray ? value.asClassArray() : value.asClass());
            }
            case DOUBLE: {
                return (T)(isArray ? value.asDoubleArray() : (double[])value.asDouble());
            }
            case ENUM: {
                return (T)(isArray ? value.asEnumArray() : value.asEnum());
            }
            case FLOAT: {
                return (T)(isArray ? value.asFloatArray() : (float[])Float.valueOf(value.asFloat()));
            }
            case INTEGER: {
                return (T)(isArray ? value.asIntArray() : (int[])value.asInt());
            }
            case LONG: {
                return (T)(isArray ? value.asLongArray() : (long[])value.asLong());
            }
            case NESTED: {
                return (T)(isArray ? value.asNestedArray() : value.asNested());
            }
            case SHORT: {
                return (T)(isArray ? value.asShortArray() : (short[])value.asShort());
            }
            case STRING: {
                return (T)(isArray ? value.asStringArray() : value.asString());
            }
        }
        return null;
    }

    public <T> T value(AnnotationInstance annotation, String name, T defaultValue) {
        T value = this.value(annotation, name);
        return value != null ? value : defaultValue;
    }

    public <T extends Enum<T>> T enumValue(AnnotationInstance annotation, String propertyName, Class<T> clazz) {
        return this.enumValue(clazz, annotation != null ? (String)this.value(annotation, propertyName) : null);
    }

    public <T extends Enum<T>> T enumValue(Class<T> clazz, AnnotationValue value) {
        return this.enumValue(clazz, value != null ? value.asEnum() : null);
    }

    public <T extends Enum<T>> T enumValue(Class<T> clazz, String value) {
        if (value == null) {
            return null;
        }
        return (T)((Enum)Stream.of((Enum[])clazz.getEnumConstants()).filter(c -> c.name().equals(value)).findFirst().orElse(null));
    }

    public List<AnnotationInstance> getRepeatableAnnotation(AnnotationTarget target, DotName singleAnnotationName, DotName repeatableAnnotationName) {
        List<AnnotationInstance> single = this.getDeclaredAnnotation(target, singleAnnotationName);
        Stream<AnnotationInstance> wrapped = this.getDeclaredAnnotation(target, repeatableAnnotationName).stream().map(a -> (AnnotationInstance[])this.value((AnnotationInstance)a, VALUE)).filter(Objects::nonNull).flatMap(Arrays::stream).map(a -> AnnotationInstance.create((DotName)a.name(), (AnnotationTarget)target, (List)a.values()));
        return Stream.concat(single.stream(), wrapped).collect(Collectors.toList());
    }

    public AnnotationInstance getMethodParameterAnnotation(MethodInfo method, int parameterIndex, DotName annotationName) {
        MethodParameterInfo target = MethodParameterInfo.create((MethodInfo)method, (short)((short)parameterIndex));
        List<AnnotationInstance> found = this.getDeclaredAnnotation((AnnotationTarget)target, annotationName);
        return found.isEmpty() ? null : found.get(0);
    }

    public AnnotationInstance getMethodParameterAnnotation(MethodInfo method, Type parameterType, DotName annotationName) {
        int parameterIndex = method.parameterTypes().indexOf(parameterType);
        return this.getMethodParameterAnnotation(method, parameterIndex, annotationName);
    }

    public Collection<AnnotationInstance> getMethodParameterAnnotations(MethodInfo method, int parameterIndex) {
        return Annotations.getDeclaredAnnotations((AnnotationTarget)MethodParameterInfo.create((MethodInfo)method, (short)((short)parameterIndex)));
    }

    public Collection<AnnotationInstance> getMethodParameterAnnotations(MethodInfo method, Type parameterType) {
        int parameterIndex = method.parameterTypes().indexOf(parameterType);
        return this.getMethodParameterAnnotations(method, parameterIndex);
    }

    public boolean hasAnnotation(AnnotationTarget target, Collection<DotName> annotationNames) {
        return Objects.nonNull(this.getAnnotation(target, annotationNames));
    }

    public boolean hasAnnotation(AnnotationTarget target, DotName ... annotationNames) {
        return Objects.nonNull(this.getAnnotation(target, annotationNames));
    }

    public AnnotationInstance getAnnotation(AnnotationTarget annotationTarget, DotName ... annotationName) {
        return this.getAnnotation(annotationTarget, Arrays.asList(annotationName));
    }

    public AnnotationInstance getAnnotation(AnnotationTarget annotationTarget, Collection<DotName> annotationNames) {
        for (DotName annotationName : annotationNames) {
            List<AnnotationInstance> found = this.getDeclaredAnnotation(annotationTarget, annotationName);
            if (found.isEmpty()) continue;
            return found.get(0);
        }
        return null;
    }

    public <T> T getAnnotationValue(AnnotationTarget target, DotName ... annotationNames) {
        return this.getAnnotationValue(target, Arrays.asList(annotationNames), VALUE, null);
    }

    public <T> T getAnnotationValue(AnnotationTarget target, List<DotName> annotationNames) {
        return this.getAnnotationValue(target, annotationNames, VALUE, null);
    }

    public <T> T getAnnotationValue(AnnotationTarget target, DotName annotationName, String propertyName) {
        return this.getAnnotationValue(target, Arrays.asList(annotationName), propertyName);
    }

    public <T> T getAnnotationValue(AnnotationTarget target, List<DotName> annotationNames, String propertyName) {
        return this.getAnnotationValue(target, annotationNames, propertyName, null);
    }

    public <T> T getAnnotationValue(AnnotationTarget target, List<DotName> annotationNames, String propertyName, T defaultValue) {
        AnnotationInstance annotation = this.getAnnotation(target, annotationNames);
        T value = null;
        if (annotation != null) {
            value = this.value(annotation, propertyName);
        }
        return value != null ? value : (T)defaultValue;
    }

    static {
        CLASS_NAME = DotName.createSimple((String)"java.lang.Class");
        ENUM_TYPE = Type.create((DotName)DotName.ENUM_NAME, (Type.Kind)Type.Kind.CLASS);
        ANNOTATION_TYPE = Type.create((DotName)DotName.createSimple((String)"java.lang.annotation.Annotation"), (Type.Kind)Type.Kind.CLASS);
        PRIMITIVES = new EnumMap<PrimitiveType.Primitive, AnnotationValue.Kind>(PrimitiveType.Primitive.class);
        PRIMITIVES.put(PrimitiveType.Primitive.BOOLEAN, AnnotationValue.Kind.BOOLEAN);
        PRIMITIVES.put(PrimitiveType.Primitive.BYTE, AnnotationValue.Kind.BYTE);
        PRIMITIVES.put(PrimitiveType.Primitive.CHAR, AnnotationValue.Kind.CHARACTER);
        PRIMITIVES.put(PrimitiveType.Primitive.DOUBLE, AnnotationValue.Kind.DOUBLE);
        PRIMITIVES.put(PrimitiveType.Primitive.FLOAT, AnnotationValue.Kind.FLOAT);
        PRIMITIVES.put(PrimitiveType.Primitive.INT, AnnotationValue.Kind.INTEGER);
        PRIMITIVES.put(PrimitiveType.Primitive.LONG, AnnotationValue.Kind.LONG);
        PRIMITIVES.put(PrimitiveType.Primitive.SHORT, AnnotationValue.Kind.SHORT);
    }
}

