/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.constants.KotlinConstants;
import io.smallrye.openapi.internal.models.media.SchemaSupport;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectLogging;
import io.smallrye.openapi.runtime.scanner.dataobject.RequirementHandler;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlinx.metadata.Attributes;
import kotlinx.metadata.KmClass;
import kotlinx.metadata.KmConstructor;
import kotlinx.metadata.KmFunction;
import kotlinx.metadata.KmProperty;
import kotlinx.metadata.KmType;
import kotlinx.metadata.KmValueParameter;
import kotlinx.metadata.jvm.JvmExtensionsKt;
import kotlinx.metadata.jvm.JvmMethodSignature;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;

public class KotlinMetadataScanner {
    private final Exception initException;
    private final AtomicBoolean exceptionLogged = new AtomicBoolean(false);
    private final Map<ClassInfo, KmClass> cache;
    private final IndexView metaIndex;

    public KotlinMetadataScanner() {
        Index singletonIndex = null;
        Exception iniException = null;
        try {
            Class<?> metadataAnnoClass = Class.forName("kotlin.Metadata");
            Class.forName("kotlinx.metadata.Attributes");
            singletonIndex = Index.of((Class[])new Class[]{metadataAnnoClass});
        }
        catch (IOException | ClassNotFoundException e) {
            iniException = e;
        }
        this.initException = iniException;
        this.metaIndex = singletonIndex;
        this.cache = new LinkedHashMap<ClassInfo, KmClass>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<ClassInfo, KmClass> eldest) {
                return this.size() > 10;
            }
        };
    }

    public void applyMetadata(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        Object declaringClass = target == null ? null : (target.kind() == AnnotationTarget.Kind.FIELD ? target.asField().declaringClass() : (target.kind() == AnnotationTarget.Kind.METHOD_PARAMETER ? target.asMethodParameter().method().declaringClass() : null));
        if (declaringClass == null || !declaringClass.hasDeclaredAnnotation(KotlinConstants.METADATA)) {
            return;
        }
        if (this.initException != null) {
            if (!this.exceptionLogged.getAndSet(true)) {
                DataObjectLogging.logger.exceptionInitializingKotlinMetadataScanner(this.initException);
            }
            return;
        }
        try {
            KmClass kmClass = this.cache.computeIfAbsent((ClassInfo)declaringClass, this::kotlinClassMetadata);
            if (kmClass == null) {
                return;
            }
            if (target.kind() == AnnotationTarget.Kind.FIELD) {
                this.applyPropertyMetadata(target.asField(), kmClass, schema, propertyKey, handler);
            } else if (target.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                this.applyParameterMetadata(target.asMethodParameter(), kmClass, schema, propertyKey, handler);
            }
        }
        catch (Exception e) {
            DataObjectLogging.logger.exceptionScanningKotlinMetadata(e);
        }
    }

    private void applyPropertyMetadata(FieldInfo field, KmClass kmClass, Schema schema, String propertyKey, RequirementHandler handler) {
        for (KmConstructor constructor : kmClass.getConstructors()) {
            if (Attributes.isSecondary((KmConstructor)constructor)) continue;
            for (KmValueParameter param : constructor.getValueParameters()) {
                if (!param.getName().equals(field.name())) continue;
                this.applyMetadata((AnnotationTarget)field, param, schema, propertyKey, handler);
                return;
            }
        }
        for (KmProperty property : kmClass.getProperties()) {
            if (!property.getName().equals(field.name())) continue;
            KotlinMetadataScanner.maybeSetNullable(property.getReturnType(), schema);
            return;
        }
    }

    private void applyParameterMetadata(MethodParameterInfo methodParam, KmClass kmClass, Schema schema, String propertyKey, RequirementHandler handler) {
        MethodInfo method = methodParam.method();
        String methodName = method.name();
        String methodDescriptor = method.descriptor();
        for (KmFunction function : kmClass.getFunctions()) {
            JvmMethodSignature signature;
            if (!function.getName().equals(methodName) || !(signature = JvmExtensionsKt.getSignature((KmFunction)function)).getDescriptor().equals(methodDescriptor)) continue;
            KmValueParameter valueParam = (KmValueParameter)function.getValueParameters().get(methodParam.position());
            this.applyMetadata((AnnotationTarget)methodParam, valueParam, schema, propertyKey, handler);
            return;
        }
    }

    private void applyMetadata(AnnotationTarget target, KmValueParameter param, Schema schema, String propertyKey, RequirementHandler handler) {
        KotlinMetadataScanner.maybeSetRequired(target, param, propertyKey, handler);
        KotlinMetadataScanner.maybeSetNullable(param.getType(), schema);
    }

    private static void maybeSetRequired(AnnotationTarget target, KmValueParameter param, String propertyKey, RequirementHandler handler) {
        if (!Attributes.getDeclaresDefaultValue((KmValueParameter)param)) {
            handler.setRequired(target, propertyKey);
        }
    }

    private static void maybeSetNullable(KmType type, Schema schema) {
        if (Attributes.isNullable((KmType)type) && SchemaSupport.getNullable(schema) == null) {
            SchemaSupport.setNullable(schema, Boolean.TRUE);
        }
    }

    private KmClass kotlinClassMetadata(ClassInfo declaringClass) {
        AnnotationInstance annotation = declaringClass.declaredAnnotation(KotlinConstants.METADATA);
        KotlinClassMetadata kotlinMeta = KotlinClassMetadata.readLenient((Metadata)KotlinMetadataProxy.create(this.metaIndex, annotation));
        if (kotlinMeta instanceof KotlinClassMetadata.Class) {
            return ((KotlinClassMetadata.Class)kotlinMeta).getKmClass();
        }
        return null;
    }

    private static class KotlinMetadataProxy {
        private KotlinMetadataProxy() {
        }

        static Metadata create(final IndexView metaIndex, final AnnotationInstance annotation) {
            return new Metadata(){

                public Class<? extends Annotation> annotationType() {
                    return Metadata.class;
                }

                public int[] bv() {
                    return annotation.valueWithDefault(metaIndex, "bv").asIntArray();
                }

                public String[] d1() {
                    return annotation.valueWithDefault(metaIndex, "d1").asStringArray();
                }

                public String[] d2() {
                    return annotation.valueWithDefault(metaIndex, "d2").asStringArray();
                }

                public int k() {
                    return annotation.valueWithDefault(metaIndex, "k").asInt();
                }

                public int[] mv() {
                    return annotation.valueWithDefault(metaIndex, "mv").asIntArray();
                }

                public String pn() {
                    return annotation.valueWithDefault(metaIndex, "pn").asString();
                }

                public int xi() {
                    return annotation.valueWithDefault(metaIndex, "xi").asInt();
                }

                public String xs() {
                    return annotation.valueWithDefault(metaIndex, "xs").asString();
                }
            };
        }
    }
}

