package io.vertx.mutiny.ext.web.multipart;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;

/**
 * A multipart form.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.multipart.MultipartForm original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.multipart.MultipartForm.class)
public class MultipartForm implements java.lang.Iterable<io.vertx.mutiny.ext.web.multipart.FormDataPart> {

  public static final io.smallrye.mutiny.vertx.TypeArg<MultipartForm> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MultipartForm((io.vertx.ext.web.multipart.MultipartForm) obj),
    MultipartForm::getDelegate
  );

  private final io.vertx.ext.web.multipart.MultipartForm delegate;
  
  public MultipartForm(io.vertx.ext.web.multipart.MultipartForm delegate) {
    this.delegate = delegate;
  }

  public MultipartForm(Object delegate) {
    this.delegate = (io.vertx.ext.web.multipart.MultipartForm)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MultipartForm() {
    this.delegate = null;
  }

  public io.vertx.ext.web.multipart.MultipartForm getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MultipartForm that = (MultipartForm) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  @Override
  public java.util.Iterator<io.vertx.mutiny.ext.web.multipart.FormDataPart> iterator() {
    java.util.function.Function<io.vertx.ext.web.multipart.FormDataPart, io.vertx.mutiny.ext.web.multipart.FormDataPart> conv = io.vertx.mutiny.ext.web.multipart.FormDataPart::newInstance;
    return new io.smallrye.mutiny.vertx.impl.MappingIterator<>(delegate.iterator(), conv);
  }

  public Multi<io.vertx.mutiny.ext.web.multipart.FormDataPart> toMulti() {
    return Multi.createFrom().iterable(this);
  }

  /**
   * @return a multipart form instance
   */
  public static io.vertx.mutiny.ext.web.multipart.MultipartForm create() { 
    io.vertx.mutiny.ext.web.multipart.MultipartForm ret = io.vertx.mutiny.ext.web.multipart.MultipartForm.newInstance((io.vertx.ext.web.multipart.MultipartForm)io.vertx.ext.web.multipart.MultipartForm.create());
    return ret;
  }

  /**
   * @param name the name of the attribute
   * @param value the value of the attribute
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.multipart.MultipartForm attribute(String name, String value) { 
    delegate.attribute(name, value);
    return this;
  }

  /**
   * @param name name of the parameter
   * @param filename filename of the file
   * @param pathname the pathname of the file
   * @param mediaType the MIME type of the file
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.multipart.MultipartForm textFileUpload(String name, String filename, String pathname, String mediaType) { 
    delegate.textFileUpload(name, filename, pathname, mediaType);
    return this;
  }

  /**
   * @param name name of the parameter
   * @param filename filename of the file
   * @param content the content of the file
   * @param mediaType the MIME type of the file
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.multipart.MultipartForm textFileUpload(String name, String filename, io.vertx.mutiny.core.buffer.Buffer content, String mediaType) { 
    delegate.textFileUpload(name, filename, content.getDelegate(), mediaType);
    return this;
  }

  /**
   * @param name name of the parameter
   * @param filename filename of the file
   * @param pathname the pathname of the file
   * @param mediaType the MIME type of the file
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.multipart.MultipartForm binaryFileUpload(String name, String filename, String pathname, String mediaType) { 
    delegate.binaryFileUpload(name, filename, pathname, mediaType);
    return this;
  }

  /**
   * @param name name of the parameter
   * @param filename filename of the file
   * @param content the content of the file
   * @param mediaType the MIME type of the file
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.multipart.MultipartForm binaryFileUpload(String name, String filename, io.vertx.mutiny.core.buffer.Buffer content, String mediaType) { 
    delegate.binaryFileUpload(name, filename, content.getDelegate(), mediaType);
    return this;
  }

  public static  MultipartForm newInstance(io.vertx.ext.web.multipart.MultipartForm arg) {
    return arg != null ? new MultipartForm(arg) : null;
  }

}
