package io.vertx.mutiny.uritemplate;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.uritemplate.ExpandOptions;

/**
 * A URI template that follows the <a href="https://datatracker.ietf.org/doc/html/rfc6570">rfc6570</a> level 4.
 *
 * <p> A template is immutable and thread safe, it can be safely shared between threads after its creation.
 * If you are sharing a template as a static variables, keep in mind that {@link io.vertx.mutiny.uritemplate.UriTemplate#of} can fail and create
 * a classloading issue.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.uritemplate.UriTemplate original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.uritemplate.UriTemplate.class)
public class UriTemplate implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<UriTemplate> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new UriTemplate((io.vertx.uritemplate.UriTemplate) obj),
    UriTemplate::getDelegate
  );

  private final io.vertx.uritemplate.UriTemplate delegate;
  
  public UriTemplate(io.vertx.uritemplate.UriTemplate delegate) {
    this.delegate = delegate;
  }

  public UriTemplate(Object delegate) {
    this.delegate = (io.vertx.uritemplate.UriTemplate)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  UriTemplate() {
    this.delegate = null;
  }

  @Override
  public io.vertx.uritemplate.UriTemplate getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    UriTemplate that = (UriTemplate) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param uri the template string
   * @return the template
   */
  public static io.vertx.mutiny.uritemplate.UriTemplate of(String uri) { 
    io.vertx.mutiny.uritemplate.UriTemplate ret = io.vertx.mutiny.uritemplate.UriTemplate.newInstance((io.vertx.uritemplate.UriTemplate)io.vertx.uritemplate.UriTemplate.of(uri));
    return ret;
  }

  /**
   * @param variables the variables
   * @return the string expansion of this template with the <code>variables</code>
   */
  public String expandToString(io.vertx.mutiny.uritemplate.Variables variables) { 
    String ret = delegate.expandToString(variables.getDelegate());
    return ret;
  }

  /**
   * @param variables the variables
   * @param options the options to control template expansion
   * @return the string expansion of this template with the <code>variables</code>
   */
  public String expandToString(io.vertx.mutiny.uritemplate.Variables variables, io.vertx.uritemplate.ExpandOptions options) { 
    String ret = delegate.expandToString(variables.getDelegate(), options);
    return ret;
  }

  public static  UriTemplate newInstance(io.vertx.uritemplate.UriTemplate arg) {
    return arg != null ? new UriTemplate(arg) : null;
  }

}
