/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.sqlclient;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.mutiny.sqlclient.PreparedStatement;
import io.vertx.mutiny.sqlclient.SqlClient;
import io.vertx.mutiny.sqlclient.Transaction;
import io.vertx.mutiny.sqlclient.spi.DatabaseMetadata;
import io.vertx.sqlclient.PrepareOptions;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.sqlclient.SqlConnection.class)
public class SqlConnection
extends SqlClient {
    public static final TypeArg<SqlConnection> __TYPE_ARG = new TypeArg(obj -> new SqlConnection((io.vertx.sqlclient.SqlConnection)obj), SqlConnection::getDelegate);
    private final io.vertx.sqlclient.SqlConnection delegate;

    public SqlConnection(io.vertx.sqlclient.SqlConnection delegate) {
        super((io.vertx.sqlclient.SqlClient)delegate);
        this.delegate = delegate;
    }

    public SqlConnection(Object delegate) {
        super((io.vertx.sqlclient.SqlClient)((io.vertx.sqlclient.SqlConnection)delegate));
        this.delegate = (io.vertx.sqlclient.SqlConnection)delegate;
    }

    SqlConnection() {
        super(null);
        this.delegate = null;
    }

    public io.vertx.sqlclient.SqlConnection getDelegate() {
        return this.delegate;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlConnection that = (SqlConnection)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @CheckReturnValue
    public Uni<PreparedStatement> prepare(String sql) {
        return AsyncResultUni.toUni(handler -> this.delegate.prepare(sql, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> PreparedStatement.newInstance(event)))));
    }

    public PreparedStatement prepareAndAwait(String sql) {
        return (PreparedStatement)this.prepare(sql).await().indefinitely();
    }

    @Fluent
    public SqlConnection prepareAndForget(String sql) {
        this.prepare(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<PreparedStatement> prepare(String sql, PrepareOptions options) {
        return AsyncResultUni.toUni(handler -> this.delegate.prepare(sql, options, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> PreparedStatement.newInstance(event)))));
    }

    public PreparedStatement prepareAndAwait(String sql, PrepareOptions options) {
        return (PreparedStatement)this.prepare(sql, options).await().indefinitely();
    }

    @Fluent
    public SqlConnection prepareAndForget(String sql, PrepareOptions options) {
        this.prepare(sql, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    private SqlConnection __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public SqlConnection exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler((Handler<Throwable>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private SqlConnection __closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public SqlConnection closeHandler(Runnable handler) {
        return this.__closeHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    @CheckReturnValue
    public Uni<Transaction> begin() {
        return AsyncResultUni.toUni(handler -> this.delegate.begin((Handler)new DelegatingHandler(handler, ar -> ar.map(event -> Transaction.newInstance(event)))));
    }

    public Transaction beginAndAwait() {
        return (Transaction)this.begin().await().indefinitely();
    }

    public void beginAndForget() {
        this.begin().subscribe().with(UniHelper.NOOP);
    }

    public Transaction transaction() {
        Transaction ret = Transaction.newInstance(this.delegate.transaction());
        return ret;
    }

    public boolean isSSL() {
        boolean ret = this.delegate.isSSL();
        return ret;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close(handler));
    }

    @Override
    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    @Override
    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public DatabaseMetadata databaseMetadata() {
        DatabaseMetadata ret = DatabaseMetadata.newInstance(this.delegate.databaseMetadata());
        return ret;
    }

    public static SqlConnection newInstance(io.vertx.sqlclient.SqlConnection arg) {
        return arg != null ? new SqlConnection(arg) : null;
    }
}

