package io.vertx.mutiny.core.shareddata;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * Shared data allows you to share data safely between different parts of your application in a safe way.
 * <p>
 * Shared data provides:
 * <ul>
 *   <li>synchronous shared maps (local)</li>
 *   <li>asynchronous maps (local or cluster-wide)</li>
 *   <li>asynchronous locks (local or cluster-wide)</li>
 *   <li>asynchronous counters (local or cluster-wide)</li>
 * </ul>
 * <p>
 * <p>
 *   <strong>WARNING</strong>: In clustered mode, asynchronous maps/locks/counters rely on distributed data structures provided by the cluster manager.
 *   Beware that the latency relative to asynchronous maps/locks/counters operations can be much higher in clustered than in local mode.
 * </p>
 * Please see the documentation for more information.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.SharedData original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.shareddata.SharedData.class)
public class SharedData implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<SharedData> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SharedData((io.vertx.core.shareddata.SharedData) obj),
    SharedData::getDelegate
  );

  private final io.vertx.core.shareddata.SharedData delegate;
  
  public SharedData(io.vertx.core.shareddata.SharedData delegate) {
    this.delegate = delegate;
  }

  public SharedData(Object delegate) {
    this.delegate = (io.vertx.core.shareddata.SharedData)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  SharedData() {
    this.delegate = null;
  }

  @Override
  public io.vertx.core.shareddata.SharedData getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SharedData that = (SharedData) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Get the cluster wide map with the specified name. The map is accessible to all nodes in the cluster and data
   * put into the map from any node is visible to to any other node.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the map
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public <K, V> io.smallrye.mutiny.Uni<io.vertx.mutiny.core.shareddata.AsyncMap<K, V>> getClusterWideMap(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getClusterWideMap(name, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.core.shareddata.AsyncMap.newInstance((io.vertx.core.shareddata.AsyncMap)event, TypeArg.unknown(), TypeArg.unknown()))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getClusterWideMap(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the map
   * @return the AsyncMap<K,V> instance produced by the operation.
   */
  public <K, V> io.vertx.mutiny.core.shareddata.AsyncMap<K, V> getClusterWideMapAndAwait(String name) { 
    return (io.vertx.mutiny.core.shareddata.AsyncMap<K, V>) getClusterWideMap(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getClusterWideMap(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.SharedData#getClusterWideMap(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.SharedData#getClusterWideMap(String)} but you don't need to compose it with other operations.
   * @param name the name of the map
   */
  public <K, V> void getClusterWideMapAndForget(String name) { 
    getClusterWideMap(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Get the {@link io.vertx.mutiny.core.shareddata.AsyncMap} with the specified name. When clustered, the map is accessible to all nodes in the cluster
   * and data put into the map from any node is visible to to any other node.
   * <p>
   *   <strong>WARNING</strong>: In clustered mode, asynchronous shared maps rely on distributed data structures provided by the cluster manager.
   *   Beware that the latency relative to asynchronous shared maps operations can be much higher in clustered than in local mode.
   * </p>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the map
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public <K, V> io.smallrye.mutiny.Uni<io.vertx.mutiny.core.shareddata.AsyncMap<K, V>> getAsyncMap(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getAsyncMap(name, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.core.shareddata.AsyncMap.newInstance((io.vertx.core.shareddata.AsyncMap)event, TypeArg.unknown(), TypeArg.unknown()))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getAsyncMap(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the map
   * @return the AsyncMap<K,V> instance produced by the operation.
   */
  public <K, V> io.vertx.mutiny.core.shareddata.AsyncMap<K, V> getAsyncMapAndAwait(String name) { 
    return (io.vertx.mutiny.core.shareddata.AsyncMap<K, V>) getAsyncMap(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getAsyncMap(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.SharedData#getAsyncMap(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.SharedData#getAsyncMap(String)} but you don't need to compose it with other operations.
   * @param name the name of the map
   */
  public <K, V> void getAsyncMapAndForget(String name) { 
    getAsyncMap(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Get the {@link io.vertx.mutiny.core.shareddata.AsyncMap} with the specified name.
   * <p>
   * When clustered, the map is <b>NOT</b> accessible to all nodes in the cluster.
   * Only the instance which created the map can put and retrieve data from this map.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the map
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public <K, V> io.smallrye.mutiny.Uni<io.vertx.mutiny.core.shareddata.AsyncMap<K, V>> getLocalAsyncMap(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getLocalAsyncMap(name, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.core.shareddata.AsyncMap.newInstance((io.vertx.core.shareddata.AsyncMap)event, TypeArg.unknown(), TypeArg.unknown()))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalAsyncMap(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the map
   * @return the AsyncMap<K,V> instance produced by the operation.
   */
  public <K, V> io.vertx.mutiny.core.shareddata.AsyncMap<K, V> getLocalAsyncMapAndAwait(String name) { 
    return (io.vertx.mutiny.core.shareddata.AsyncMap<K, V>) getLocalAsyncMap(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalAsyncMap(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalAsyncMap(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalAsyncMap(String)} but you don't need to compose it with other operations.
   * @param name the name of the map
   */
  public <K, V> void getLocalAsyncMapAndForget(String name) { 
    getLocalAsyncMap(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Get an asynchronous lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the lock
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.shareddata.Lock> getLock(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getLock(name, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLock(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the lock
   * @return the Lock instance produced by the operation.
   */
  public io.vertx.mutiny.core.shareddata.Lock getLockAndAwait(String name) { 
    return (io.vertx.mutiny.core.shareddata.Lock) getLock(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLock(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.SharedData#getLock(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.SharedData#getLock(String)} but you don't need to compose it with other operations.
   * @param name the name of the lock
   */
  public void getLockAndForget(String name) { 
    getLock(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.core.shareddata.SharedData#getLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.shareddata.Lock> getLockWithTimeout(String name, long timeout) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getLockWithTimeout(name, timeout, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLockWithTimeout(String,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return the Lock instance produced by the operation.
   */
  public io.vertx.mutiny.core.shareddata.Lock getLockWithTimeoutAndAwait(String name, long timeout) { 
    return (io.vertx.mutiny.core.shareddata.Lock) getLockWithTimeout(name, timeout).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLockWithTimeout(String,long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.SharedData#getLockWithTimeout(String,long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.SharedData#getLockWithTimeout(String,long)} but you don't need to compose it with other operations.
   * @param name the name of the lock
   * @param timeout the timeout in ms
   */
  public void getLockWithTimeoutAndForget(String name, long timeout) { 
    getLockWithTimeout(name, timeout).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Get an asynchronous local lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the lock
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.shareddata.Lock> getLocalLock(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getLocalLock(name, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalLock(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the lock
   * @return the Lock instance produced by the operation.
   */
  public io.vertx.mutiny.core.shareddata.Lock getLocalLockAndAwait(String name) { 
    return (io.vertx.mutiny.core.shareddata.Lock) getLocalLock(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalLock(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalLock(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalLock(String)} but you don't need to compose it with other operations.
   * @param name the name of the lock
   */
  public void getLocalLockAndForget(String name) { 
    getLocalLock(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.shareddata.Lock> getLocalLockWithTimeout(String name, long timeout) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getLocalLockWithTimeout(name, timeout, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalLockWithTimeout(String,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return the Lock instance produced by the operation.
   */
  public io.vertx.mutiny.core.shareddata.Lock getLocalLockWithTimeoutAndAwait(String name, long timeout) { 
    return (io.vertx.mutiny.core.shareddata.Lock) getLocalLockWithTimeout(name, timeout).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalLockWithTimeout(String,long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalLockWithTimeout(String,long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalLockWithTimeout(String,long)} but you don't need to compose it with other operations.
   * @param name the name of the lock
   * @param timeout the timeout in ms
   */
  public void getLocalLockWithTimeoutAndForget(String name, long timeout) { 
    getLocalLockWithTimeout(name, timeout).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Get an asynchronous counter. The counter will be passed to the handler.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the counter.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.shareddata.Counter> getCounter(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getCounter(name, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.core.shareddata.Counter.newInstance((io.vertx.core.shareddata.Counter)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getCounter(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the counter.
   * @return the Counter instance produced by the operation.
   */
  public io.vertx.mutiny.core.shareddata.Counter getCounterAndAwait(String name) { 
    return (io.vertx.mutiny.core.shareddata.Counter) getCounter(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getCounter(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.SharedData#getCounter(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.SharedData#getCounter(String)} but you don't need to compose it with other operations.
   * @param name the name of the counter.
   */
  public void getCounterAndForget(String name) { 
    getCounter(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Get an asynchronous local counter. The counter will be passed to the handler.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the counter.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.shareddata.Counter> getLocalCounter(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getLocalCounter(name, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.core.shareddata.Counter.newInstance((io.vertx.core.shareddata.Counter)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalCounter(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the counter.
   * @return the Counter instance produced by the operation.
   */
  public io.vertx.mutiny.core.shareddata.Counter getLocalCounterAndAwait(String name) { 
    return (io.vertx.mutiny.core.shareddata.Counter) getLocalCounter(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalCounter(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalCounter(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalCounter(String)} but you don't need to compose it with other operations.
   * @param name the name of the counter.
   */
  public void getLocalCounterAndForget(String name) { 
    getLocalCounter(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param name the name of the map
   * @return the map
   */
  public <K, V> io.vertx.mutiny.core.shareddata.LocalMap<K, V> getLocalMap(String name) { 
    io.vertx.mutiny.core.shareddata.LocalMap<K, V> ret = io.vertx.mutiny.core.shareddata.LocalMap.newInstance((io.vertx.core.shareddata.LocalMap)delegate.getLocalMap(name), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  public static  SharedData newInstance(io.vertx.core.shareddata.SharedData arg) {
    return arg != null ? new SharedData(arg) : null;
  }

}
