package io.vertx.mutiny.core.dns;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * Provides a way to asynchronously lookup information from DNS servers.
 * <p>
 * Please consult the documentation for more information on DNS clients.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.dns.DnsClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.dns.DnsClient.class)
public class DnsClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<DnsClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new DnsClient((io.vertx.core.dns.DnsClient) obj),
    DnsClient::getDelegate
  );

  private final io.vertx.core.dns.DnsClient delegate;
  
  public DnsClient(io.vertx.core.dns.DnsClient delegate) {
    this.delegate = delegate;
  }

  public DnsClient(Object delegate) {
    this.delegate = (io.vertx.core.dns.DnsClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  DnsClient() {
    this.delegate = null;
  }

  public io.vertx.core.dns.DnsClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DnsClient that = (DnsClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Try to lookup the A (ipv4) or AAAA (ipv6) record for the given name. The first found will be used.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name to resolve
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> lookup(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lookup(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.dns.DnsClient#lookup(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name to resolve
   * @return the String instance produced by the operation.
   */
  public String lookupAndAwait(String name) { 
    return (String) lookup(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.dns.DnsClient#lookup(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.dns.DnsClient#lookup(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.dns.DnsClient#lookup(String)} but you don't need to compose it with other operations.
   * @param name the name to resolve
   * @return the instance of DnsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.dns.DnsClient lookupAndForget(String name) { 
    lookup(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Try to lookup the A (ipv4) record for the given name. The first found will be used.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name to resolve
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> lookup4(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lookup4(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.dns.DnsClient#lookup4(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name to resolve
   * @return the String instance produced by the operation.
   */
  public String lookup4AndAwait(String name) { 
    return (String) lookup4(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.dns.DnsClient#lookup4(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.dns.DnsClient#lookup4(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.dns.DnsClient#lookup4(String)} but you don't need to compose it with other operations.
   * @param name the name to resolve
   * @return the instance of DnsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.dns.DnsClient lookup4AndForget(String name) { 
    lookup4(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Try to lookup the AAAA (ipv6) record for the given name. The first found will be used.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name to resolve
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> lookup6(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lookup6(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.dns.DnsClient#lookup6(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name to resolve
   * @return the String instance produced by the operation.
   */
  public String lookup6AndAwait(String name) { 
    return (String) lookup6(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.dns.DnsClient#lookup6(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.dns.DnsClient#lookup6(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.dns.DnsClient#lookup6(String)} but you don't need to compose it with other operations.
   * @param name the name to resolve
   * @return the instance of DnsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.dns.DnsClient lookup6AndForget(String name) { 
    lookup6(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Try to resolve all A (ipv4) records for the given name.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name to resolve
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<String>> resolveA(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.resolveA(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.dns.DnsClient#resolveA(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name to resolve
   * @return the List<String> instance produced by the operation.
   */
  public List<String> resolveAAndAwait(String name) { 
    return (List<String>) resolveA(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.dns.DnsClient#resolveA(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.dns.DnsClient#resolveA(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.dns.DnsClient#resolveA(String)} but you don't need to compose it with other operations.
   * @param name the name to resolve
   * @return the instance of DnsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.dns.DnsClient resolveAAndForget(String name) { 
    resolveA(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Try to resolve all AAAA (ipv6) records for the given name.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name to resolve
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<String>> resolveAAAA(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.resolveAAAA(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.dns.DnsClient#resolveAAAA(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name to resolve
   * @return the List<String> instance produced by the operation.
   */
  public List<String> resolveAAAAAndAwait(String name) { 
    return (List<String>) resolveAAAA(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.dns.DnsClient#resolveAAAA(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.dns.DnsClient#resolveAAAA(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.dns.DnsClient#resolveAAAA(String)} but you don't need to compose it with other operations.
   * @param name the name to resolve
   * @return the instance of DnsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.dns.DnsClient resolveAAAAAndForget(String name) { 
    resolveAAAA(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Try to resolve the CNAME record for the given name.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name to resolve the CNAME for
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<String>> resolveCNAME(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.resolveCNAME(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.dns.DnsClient#resolveCNAME(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name to resolve the CNAME for
   * @return the List<String> instance produced by the operation.
   */
  public List<String> resolveCNAMEAndAwait(String name) { 
    return (List<String>) resolveCNAME(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.dns.DnsClient#resolveCNAME(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.dns.DnsClient#resolveCNAME(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.dns.DnsClient#resolveCNAME(String)} but you don't need to compose it with other operations.
   * @param name the name to resolve the CNAME for
   * @return the instance of DnsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.dns.DnsClient resolveCNAMEAndForget(String name) { 
    resolveCNAME(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Try to resolve the MX records for the given name.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name for which the MX records should be resolved
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<io.vertx.mutiny.core.dns.MxRecord>> resolveMX(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.resolveMX(name, new Handler<AsyncResult<java.util.List<io.vertx.core.dns.MxRecord>>>() {
      public void handle(AsyncResult<java.util.List<io.vertx.core.dns.MxRecord>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.mutiny.core.dns.MxRecord.newInstance((io.vertx.core.dns.MxRecord)elt)).collect(java.util.stream.Collectors.toList())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.dns.DnsClient#resolveMX(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name for which the MX records should be resolved
   * @return the List<MxRecord> instance produced by the operation.
   */
  public List<io.vertx.mutiny.core.dns.MxRecord> resolveMXAndAwait(String name) { 
    return (List<io.vertx.mutiny.core.dns.MxRecord>) resolveMX(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.dns.DnsClient#resolveMX(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.dns.DnsClient#resolveMX(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.dns.DnsClient#resolveMX(String)} but you don't need to compose it with other operations.
   * @param name the name for which the MX records should be resolved
   * @return the instance of DnsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.dns.DnsClient resolveMXAndForget(String name) { 
    resolveMX(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Try to resolve the TXT records for the given name.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name for which the TXT records should be resolved
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<String>> resolveTXT(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.resolveTXT(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.dns.DnsClient#resolveTXT(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name for which the TXT records should be resolved
   * @return the List<String> instance produced by the operation.
   */
  public List<String> resolveTXTAndAwait(String name) { 
    return (List<String>) resolveTXT(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.dns.DnsClient#resolveTXT(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.dns.DnsClient#resolveTXT(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.dns.DnsClient#resolveTXT(String)} but you don't need to compose it with other operations.
   * @param name the name for which the TXT records should be resolved
   * @return the instance of DnsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.dns.DnsClient resolveTXTAndForget(String name) { 
    resolveTXT(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Try to resolve the PTR record for the given name.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name to resolve the PTR for
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> resolvePTR(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.resolvePTR(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.dns.DnsClient#resolvePTR(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name to resolve the PTR for
   * @return the String instance produced by the operation.
   */
  public String resolvePTRAndAwait(String name) { 
    return (String) resolvePTR(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.dns.DnsClient#resolvePTR(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.dns.DnsClient#resolvePTR(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.dns.DnsClient#resolvePTR(String)} but you don't need to compose it with other operations.
   * @param name the name to resolve the PTR for
   * @return the instance of DnsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.dns.DnsClient resolvePTRAndForget(String name) { 
    resolvePTR(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Try to resolve the NS records for the given name.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name for which the NS records should be resolved
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<String>> resolveNS(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.resolveNS(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.dns.DnsClient#resolveNS(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name for which the NS records should be resolved
   * @return the List<String> instance produced by the operation.
   */
  public List<String> resolveNSAndAwait(String name) { 
    return (List<String>) resolveNS(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.dns.DnsClient#resolveNS(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.dns.DnsClient#resolveNS(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.dns.DnsClient#resolveNS(String)} but you don't need to compose it with other operations.
   * @param name the name for which the NS records should be resolved
   * @return the instance of DnsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.dns.DnsClient resolveNSAndForget(String name) { 
    resolveNS(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Try to resolve the SRV records for the given name.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name for which the SRV records should be resolved
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<io.vertx.mutiny.core.dns.SrvRecord>> resolveSRV(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.resolveSRV(name, new Handler<AsyncResult<java.util.List<io.vertx.core.dns.SrvRecord>>>() {
      public void handle(AsyncResult<java.util.List<io.vertx.core.dns.SrvRecord>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.mutiny.core.dns.SrvRecord.newInstance((io.vertx.core.dns.SrvRecord)elt)).collect(java.util.stream.Collectors.toList())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.dns.DnsClient#resolveSRV(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name for which the SRV records should be resolved
   * @return the List<SrvRecord> instance produced by the operation.
   */
  public List<io.vertx.mutiny.core.dns.SrvRecord> resolveSRVAndAwait(String name) { 
    return (List<io.vertx.mutiny.core.dns.SrvRecord>) resolveSRV(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.dns.DnsClient#resolveSRV(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.dns.DnsClient#resolveSRV(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.dns.DnsClient#resolveSRV(String)} but you don't need to compose it with other operations.
   * @param name the name for which the SRV records should be resolved
   * @return the instance of DnsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.dns.DnsClient resolveSRVAndForget(String name) { 
    resolveSRV(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Try to do a reverse lookup of an IP address. This is basically the same as doing trying to resolve a PTR record
   * but allows you to just pass in the IP address and not a valid ptr query string.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param ipaddress the IP address to resolve the PTR for
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> reverseLookup(String ipaddress) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.reverseLookup(ipaddress, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.dns.DnsClient#reverseLookup(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param ipaddress the IP address to resolve the PTR for
   * @return the String instance produced by the operation.
   */
  public String reverseLookupAndAwait(String ipaddress) { 
    return (String) reverseLookup(ipaddress).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.dns.DnsClient#reverseLookup(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.dns.DnsClient#reverseLookup(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.dns.DnsClient#reverseLookup(String)} but you don't need to compose it with other operations.
   * @param ipaddress the IP address to resolve the PTR for
   * @return the instance of DnsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.dns.DnsClient reverseLookupAndForget(String ipaddress) { 
    reverseLookup(ipaddress).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  public static  DnsClient newInstance(io.vertx.core.dns.DnsClient arg) {
    return arg != null ? new DnsClient(arg) : null;
  }

}
