/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscription;

public class MultiLogger<T>
extends AbstractMultiOperator<T, T> {
    private final String identifier;
    private final AtomicLong increment = new AtomicLong(0L);

    public MultiLogger(Multi<? extends T> upstream, String identifier) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        String id = ParameterValidation.nonNull(identifier, "identifier");
        if (id.isEmpty()) {
            throw new IllegalArgumentException("The identifier cannot be an empty string");
        }
        this.identifier = id;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> subscriber) {
        this.upstream.subscribe().withSubscriber(new MultiLoggerProcessor(subscriber, this.increment.getAndIncrement()));
    }

    private class MultiLoggerProcessor
    extends MultiOperatorProcessor<T, T> {
        private final String processorIdentifier;

        public MultiLoggerProcessor(MultiSubscriber<? super T> downstream, long increment) {
            super(downstream);
            this.processorIdentifier = MultiLogger.this.identifier + "." + increment;
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            if (!this.isDone()) {
                Infrastructure.logFromOperator(this.processorIdentifier, "onSubscribe", null, null);
                super.onSubscribe(subscription);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (!this.isDone()) {
                Infrastructure.logFromOperator(this.processorIdentifier, "onFailure", null, failure);
                super.onFailure(failure);
            }
        }

        @Override
        public void onItem(T item) {
            if (!this.isDone()) {
                Infrastructure.logFromOperator(this.processorIdentifier, "onItem", item, null);
                super.onItem(item);
            }
        }

        @Override
        public void onCompletion() {
            if (!this.isDone()) {
                Infrastructure.logFromOperator(this.processorIdentifier, "onCompletion", null, null);
                super.onCompletion();
            }
        }

        @Override
        public void request(long numberOfItems) {
            if (!this.isDone()) {
                Infrastructure.logFromOperator(this.processorIdentifier, "request", numberOfItems, null);
                super.request(numberOfItems);
            }
        }

        @Override
        public void cancel() {
            if (!this.isDone()) {
                Infrastructure.logFromOperator(this.processorIdentifier, "cancel", null, null);
                super.cancel();
            }
        }
    }
}

