/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.subscription.Cancellable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

public class UniSubscribeToCompletionStage {
    public static <T> CompletableFuture<T> subscribe(Uni<T> uni) {
        final AtomicReference<Cancellable> cancellable = new AtomicReference<Cancellable>();
        CompletableFuture future = new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                Cancellable c;
                boolean cancelled = super.cancel(mayInterruptIfRunning);
                if (cancelled && (c = (Cancellable)cancellable.get()) != null) {
                    c.cancel();
                }
                return cancelled;
            }
        };
        cancellable.set(uni.subscribe().with(future::complete, future::completeExceptionally));
        return Infrastructure.wrapCompletableFuture(future);
    }
}

