/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.spies;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.spies.UniSpyBase;
import io.smallrye.mutiny.subscription.UniSubscriber;

public class UniOnItemOrFailureSpy<T>
extends UniSpyBase<T> {
    private volatile T lastItem;
    private volatile Throwable lastFailure;

    UniOnItemOrFailureSpy(Uni<T> upstream) {
        super(upstream);
    }

    public boolean hasFailed() {
        return this.lastFailure != null;
    }

    public T lastItem() {
        return this.lastItem;
    }

    @Override
    public void reset() {
        super.reset();
        this.lastItem = null;
        this.lastFailure = null;
    }

    public Throwable lastFailure() {
        return this.lastFailure;
    }

    @Override
    protected void subscribing(UniSubscriber<? super T> downstream) {
        this.upstream().onItemOrFailure().invoke((? super T item, Throwable failure) -> {
            UniOnItemOrFailureSpy uniOnItemOrFailureSpy = this;
            synchronized (uniOnItemOrFailureSpy) {
                this.lastItem = item;
                this.lastFailure = failure;
            }
            this.incrementInvocationCount();
        }).subscribe().withSubscriber(downstream);
    }

    @Override
    public String toString() {
        return "UniOnItemOrFailureSpy{lastItem=" + this.lastItem + ", lastFailure=" + this.lastFailure + "} " + super.toString();
    }
}

