/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.inject.ConfigException;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.Pos;

@MessageBundle(projectCode="SRCFG", length=5)
public interface InjectionMessages {
    public static final InjectionMessages msg = (InjectionMessages)Messages.getBundle(InjectionMessages.class);

    @Message(id=2000, value="Failed to Inject @ConfigProperty for key %s into %s since the config property could not be found in any config source")
    public ConfigException noConfigValue(@Param @Pos(value={1}) String var1, @Pos(value={2}) String var2);

    @Message(id=2001, value="Failed to Inject @ConfigProperty for key %s into %s %s")
    public ConfigException retrieveConfigFailure(@Param @Pos(value={1}) String var1, @Pos(value={2}) String var2, @Pos(value={3}) String var3, @Cause Exception var4);

    @Message(id=2002, value="Could not find default name for @ConfigProperty InjectionPoint %s")
    public IllegalStateException noConfigPropertyDefaultName(InjectionPoint var1);

    @Message(id=2003, value="Unhandled ConfigProperty")
    public IllegalStateException unhandledConfigProperty();

    @Message(id=2004, value="Required property %s not found")
    public NoSuchElementException propertyNotFound(String var1);

    @Message(id=2005, value="Type has no raw type class: %s")
    public IllegalArgumentException noRawType(Type var1);

    @Message(id=2006, value="The property %s cannot be converted to %s")
    public IllegalArgumentException illegalConversion(String var1, Type var2);

    @Message(id=2007, value="No Converter registered for %s")
    public IllegalArgumentException noRegisteredConverter(Class<?> var1);

    public static String formatInjectionPoint(InjectionPoint injectionPoint) {
        Member member = injectionPoint.getMember();
        StringBuilder sb = new StringBuilder();
        sb.append(member.getDeclaringClass().getName());
        if (member instanceof Field) {
            sb.append("." + member.getName());
        } else if (member instanceof Method) {
            sb.append("." + member.getName());
            InjectionMessages.appendParameterTypes(sb, (Method)member);
        } else if (member instanceof Constructor) {
            InjectionMessages.appendParameterTypes(sb, (Constructor)member);
        }
        return sb.toString();
    }

    public static void appendParameterTypes(StringBuilder sb, Executable executable) {
        sb.append("(" + Arrays.stream(executable.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ")");
    }
}

