/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.CodeBuilder;
import io.smallrye.classfile.CodeModel;
import io.smallrye.classfile.CodeTransform;
import io.smallrye.classfile.CustomAttribute;
import io.smallrye.classfile.MethodBuilder;
import io.smallrye.classfile.MethodElement;
import io.smallrye.classfile.MethodModel;
import io.smallrye.classfile.attribute.CodeAttribute;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.AbstractDirectBuilder;
import io.smallrye.classfile.impl.AbstractElement;
import io.smallrye.classfile.impl.BufWriterImpl;
import io.smallrye.classfile.impl.BufferedCodeBuilder;
import io.smallrye.classfile.impl.ClassFileImpl;
import io.smallrye.classfile.impl.DirectCodeBuilder;
import io.smallrye.classfile.impl.SplitConstantPool;
import io.smallrye.classfile.impl.TerminalMethodBuilder;
import io.smallrye.classfile.impl.UnboundAttribute;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.MethodTypeDesc;
import java.util.Objects;
import java.util.function.Consumer;

public final class DirectMethodBuilder
extends AbstractDirectBuilder<MethodModel>
implements TerminalMethodBuilder,
Util.Writable {
    final Utf8Entry name;
    final Utf8Entry desc;
    int flags;
    int[] parameterSlots;

    public DirectMethodBuilder(SplitConstantPool constantPool, ClassFileImpl context, Utf8Entry nameInfo, Utf8Entry typeInfo, int flags, MethodModel original) {
        super(constantPool, context);
        this.setOriginal(original);
        this.name = Objects.requireNonNull(nameInfo);
        this.desc = Objects.requireNonNull(typeInfo);
        this.flags = Util.checkFlags(flags);
    }

    @Override
    public MethodBuilder withFlags(int flags) {
        this.setFlags(Util.checkFlags(flags));
        return this;
    }

    void setFlags(int flags) {
        boolean isStatic;
        boolean wasStatic = (this.flags & 8) != 0;
        boolean bl = isStatic = (flags & 8) != 0;
        if (wasStatic != isStatic) {
            throw new IllegalArgumentException("Cannot change ACC_STATIC flag of method");
        }
        this.flags = flags;
    }

    @Override
    public Utf8Entry methodName() {
        return this.name;
    }

    @Override
    public Utf8Entry methodType() {
        return this.desc;
    }

    @Override
    public MethodTypeDesc methodTypeSymbol() {
        return Util.methodTypeSymbol(this.methodType());
    }

    @Override
    public int methodFlags() {
        return this.flags;
    }

    @Override
    public int parameterSlot(int paramNo) {
        if (paramNo == 0) {
            return (this.flags & 8) != 0 ? 0 : 1;
        }
        if (this.parameterSlots == null) {
            this.parameterSlots = Util.parseParameterSlots(this.methodFlags(), this.methodTypeSymbol());
        }
        return this.parameterSlots[paramNo];
    }

    @Override
    public BufferedCodeBuilder bufferedCodeBuilder(CodeModel original) {
        return new BufferedCodeBuilder(this, this.constantPool, this.context, original);
    }

    @Override
    public MethodBuilder with(MethodElement element) {
        if (element instanceof AbstractElement) {
            AbstractElement ae = (AbstractElement)((Object)element);
            ae.writeTo(this);
        } else {
            this.writeAttribute((CustomAttribute)Objects.requireNonNull(element));
        }
        return this;
    }

    private MethodBuilder withCode(CodeModel original, Consumer<? super CodeBuilder> handler) {
        UnboundAttribute<CodeAttribute> cb = DirectCodeBuilder.build(this, handler, this.constantPool, this.context, original);
        this.writeAttribute(cb);
        return this;
    }

    @Override
    public MethodBuilder withCode(Consumer<? super CodeBuilder> handler) {
        return this.withCode(null, handler);
    }

    @Override
    public MethodBuilder transformCode(final CodeModel code, final CodeTransform transform) {
        return this.withCode(code, (Consumer<? super CodeBuilder>)new Consumer<CodeBuilder>(){

            @Override
            public void accept(CodeBuilder builder) {
                builder.transform(code, transform);
            }
        });
    }

    public DirectMethodBuilder run(Consumer<? super MethodBuilder> handler) {
        handler.accept(this);
        return this;
    }

    @Override
    public void writeTo(BufWriterImpl buf) {
        buf.writeU2U2U2(this.flags, buf.cpIndex(this.name), buf.cpIndex(this.desc));
        this.attributes.writeTo(buf);
    }
}

