/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.constantpool;

import io.smallrye.classfile.BootstrapMethodEntry;
import io.smallrye.classfile.constantpool.PoolEntry;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ConstantPool
extends Iterable<PoolEntry> {
    public PoolEntry entryByIndex(int var1);

    public int size();

    public <T extends PoolEntry> T entryByIndex(int var1, Class<T> var2);

    @Override
    default public Iterator<PoolEntry> iterator() {
        return new Iterator<PoolEntry>(){
            int index = 1;

            @Override
            public boolean hasNext() {
                return this.index < ConstantPool.this.size();
            }

            @Override
            public PoolEntry next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                PoolEntry e = ConstantPool.this.entryByIndex(this.index);
                this.index += e.width();
                return e;
            }
        };
    }

    public BootstrapMethodEntry bootstrapMethodEntry(int var1);

    public int bootstrapMethodCount();
}

