/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile;

import io.smallrye.classfile.ClassElement;
import io.smallrye.classfile.ClassFileBuilder;
import io.smallrye.classfile.ClassFileVersion;
import io.smallrye.classfile.CodeBuilder;
import io.smallrye.classfile.FieldBuilder;
import io.smallrye.classfile.FieldModel;
import io.smallrye.classfile.FieldTransform;
import io.smallrye.classfile.Interfaces;
import io.smallrye.classfile.MethodBuilder;
import io.smallrye.classfile.MethodModel;
import io.smallrye.classfile.MethodTransform;
import io.smallrye.classfile.Superclass;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.extras.reflect.AccessFlag;
import io.smallrye.classfile.impl.AccessFlagsImpl;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClassBuilder
extends ClassFileBuilder<ClassElement, ClassBuilder> {
    default public ClassBuilder withVersion(int major, int minor) {
        return (ClassBuilder)this.with(ClassFileVersion.of(major, minor));
    }

    default public ClassBuilder withFlags(int flags) {
        return (ClassBuilder)this.with(new AccessFlagsImpl(AccessFlag.Location.CLASS, flags));
    }

    default public ClassBuilder withFlags(AccessFlag ... flags) {
        return (ClassBuilder)this.with(new AccessFlagsImpl(AccessFlag.Location.CLASS, flags));
    }

    default public ClassBuilder withSuperclass(ClassEntry superclassEntry) {
        return (ClassBuilder)this.with(Superclass.of(superclassEntry));
    }

    default public ClassBuilder withSuperclass(ClassDesc desc) {
        return this.withSuperclass(this.constantPool().classEntry(desc));
    }

    default public ClassBuilder withInterfaces(List<ClassEntry> interfaces) {
        return (ClassBuilder)this.with(Interfaces.of(interfaces));
    }

    default public ClassBuilder withInterfaces(ClassEntry ... interfaces) {
        return this.withInterfaces(List.of(interfaces));
    }

    default public ClassBuilder withInterfaceSymbols(List<ClassDesc> interfaces) {
        return this.withInterfaces(Util.entryList(interfaces));
    }

    default public ClassBuilder withInterfaceSymbols(ClassDesc ... interfaces) {
        return this.withInterfaceSymbols(Arrays.asList(interfaces));
    }

    public ClassBuilder withField(Utf8Entry var1, Utf8Entry var2, Consumer<? super FieldBuilder> var3);

    default public ClassBuilder withField(Utf8Entry name, Utf8Entry descriptor, int flags) {
        return this.withField(name, descriptor, Util.buildingFlags(flags));
    }

    default public ClassBuilder withField(String name, ClassDesc descriptor, Consumer<? super FieldBuilder> handler) {
        return this.withField(this.constantPool().utf8Entry(name), this.constantPool().utf8Entry(descriptor), handler);
    }

    default public ClassBuilder withField(String name, ClassDesc descriptor, int flags) {
        return this.withField(this.constantPool().utf8Entry(name), this.constantPool().utf8Entry(descriptor), flags);
    }

    public ClassBuilder transformField(FieldModel var1, FieldTransform var2);

    public ClassBuilder withMethod(Utf8Entry var1, Utf8Entry var2, int var3, Consumer<? super MethodBuilder> var4);

    default public ClassBuilder withMethodBody(Utf8Entry name, Utf8Entry descriptor, int methodFlags, Consumer<? super CodeBuilder> handler) {
        return this.withMethod(name, descriptor, methodFlags, Util.buildingCode(handler));
    }

    default public ClassBuilder withMethod(String name, MethodTypeDesc descriptor, int methodFlags, Consumer<? super MethodBuilder> handler) {
        return this.withMethod(this.constantPool().utf8Entry(name), this.constantPool().utf8Entry(descriptor), methodFlags, handler);
    }

    default public ClassBuilder withMethodBody(String name, MethodTypeDesc descriptor, int methodFlags, Consumer<? super CodeBuilder> handler) {
        return this.withMethod(name, descriptor, methodFlags, Util.buildingCode(handler));
    }

    public ClassBuilder transformMethod(MethodModel var1, MethodTransform var2);
}

