/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.mockmvc.internal;

import io.restassured.module.mockmvc.config.MockMvcConfig;
import io.restassured.module.mockmvc.internal.SpringSecurityTestClassPathChecker;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.security.test.web.servlet.setup.SecurityMockMvcConfigurers;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MockMvcBuilder;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.setup.AbstractMockMvcBuilder;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.test.web.servlet.setup.StandaloneMockMvcBuilder;
import org.springframework.web.context.WebApplicationContext;

public class MockMvcFactory {
    private Object mockMvc;

    MockMvcFactory() {
        this.mockMvc = null;
    }

    public MockMvcFactory(MockMvc mockMvc) {
        this.mockMvc = mockMvc;
    }

    public MockMvcFactory(MockMvcBuilder mockMvc) {
        this.mockMvc = mockMvc;
    }

    public synchronized MockMvc build(MockMvcConfig config) {
        MockMvc mockMvcToReturn;
        if (!this.isAssigned()) {
            throw new IllegalStateException("You haven't configured a MockMVC instance. You can do this statically\n\nRestAssuredMockMvc.mockMvc(..)\nRestAssuredMockMvc.standaloneSetup(..);\nRestAssuredMockMvc.webAppContextSetup(..);\n\nor using the DSL:\n\ngiven().\n\t\tmockMvc(..). ..\n");
        }
        if (this.mockMvc instanceof MockMvc) {
            mockMvcToReturn = (MockMvc)this.mockMvc;
        } else if (this.mockMvc instanceof AbstractMockMvcBuilder) {
            AbstractMockMvcBuilder builder = (AbstractMockMvcBuilder)this.mockMvc;
            if (config.shouldAutomaticallyApplySpringSecurityMockMvcConfigurer() && SpringSecurityTestClassPathChecker.isSpringSecurityTestInClasspath()) {
                MockMvcConfigurer configurer;
                List<MockMvcConfigurer> configurers = this.getAlreadyConfiguredMockMacConfigurers(builder);
                boolean isOkToAdd = true;
                Iterator<MockMvcConfigurer> iterator = configurers.iterator();
                while (iterator.hasNext()) {
                    configurer = iterator.next();
                    if (configurer.getClass().getName().equals("org.springframework.security.test.web.servlet.setup.SecurityMockMvcConfigurer")) {
                        isOkToAdd = false;
                        break;
                    }
                    if (!(configurer instanceof ConditionalSpringMockMvcConfigurer)) continue;
                    iterator.remove();
                }
                if (isOkToAdd) {
                    configurer = SecurityMockMvcConfigurers.springSecurity();
                    builder.apply((MockMvcConfigurer)new ConditionalSpringMockMvcConfigurer(builder instanceof StandaloneMockMvcBuilder, configurer));
                }
            }
            mockMvcToReturn = builder.build();
        } else if (this.mockMvc instanceof MockMvcBuilder) {
            mockMvcToReturn = ((MockMvcBuilder)this.mockMvc).build();
        } else {
            throw new IllegalStateException("Cannot construct MockMvc instance because mock mvc instance is of type " + this.mockMvc.getClass().getName());
        }
        this.mockMvc = mockMvcToReturn;
        return mockMvcToReturn;
    }

    private List<MockMvcConfigurer> getAlreadyConfiguredMockMacConfigurers(AbstractMockMvcBuilder builder) {
        try {
            Field configurers = AbstractMockMvcBuilder.class.getDeclaredField("configurers");
            configurers.setAccessible(true);
            Object o = configurers.get(builder);
            configurers.setAccessible(false);
            return (List)o;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public boolean isAssigned() {
        return this.mockMvc != null;
    }

    private static class ConditionalSpringMockMvcConfigurer
    implements MockMvcConfigurer {
        private static final String SPRING_SECURITY_FILTER_CHAIN = "springSecurityFilterChain";
        private final boolean isStandaloneSetup;
        private final MockMvcConfigurer configurer;

        public ConditionalSpringMockMvcConfigurer(boolean isStandaloneSetup, MockMvcConfigurer configurer) {
            this.isStandaloneSetup = isStandaloneSetup;
            this.configurer = configurer;
        }

        public void afterConfigurerAdded(ConfigurableMockMvcBuilder<?> builder) {
            if (!this.isStandaloneSetup) {
                this.configurer.afterConfigurerAdded(builder);
            }
        }

        public RequestPostProcessor beforeMockMvcCreated(ConfigurableMockMvcBuilder<?> builder, WebApplicationContext context) {
            if (!context.containsBean(SPRING_SECURITY_FILTER_CHAIN)) {
                return null;
            }
            return this.configurer.beforeMockMvcCreated(builder, context);
        }
    }
}

