/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.identity;

import io.quarkus.security.credential.Credential;
import java.security.Permission;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;

public interface SecurityIdentity {
    public static final String USER_ATTRIBUTE = "quarkus.user";

    public Principal getPrincipal();

    public boolean isAnonymous();

    public Set<String> getRoles();

    default public boolean hasRole(String role) {
        return this.getRoles().contains(role);
    }

    public <T extends Credential> T getCredential(Class<T> var1);

    public Set<Credential> getCredentials();

    public <T> T getAttribute(String var1);

    public Map<String, Object> getAttributes();

    public CompletionStage<Boolean> checkPermission(Permission var1);

    default public boolean checkPermissionBlocking(Permission permission) {
        try {
            return this.checkPermission(permission).toCompletableFuture().join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }
}

