/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.TemplateInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jboss.logging.Logger;

public abstract class TemplateInstanceBase
implements TemplateInstance {
    private static final Logger LOG = Logger.getLogger(TemplateInstanceBase.class);
    static final String DATA_MAP_KEY = "io.quarkus.qute.dataMap";
    static final Map<String, Object> EMPTY_DATA_MAP = Collections.singletonMap("io.quarkus.qute.dataMap", true);
    protected Object data;
    protected DataMap dataMap;
    protected final Map<String, Object> attributes = new HashMap<String, Object>();
    protected List<Runnable> renderedActions;

    @Override
    public TemplateInstance data(Object data) {
        this.data = data;
        this.dataMap = null;
        return this;
    }

    @Override
    public TemplateInstance data(String key, Object data) {
        this.data = null;
        if (this.dataMap == null) {
            this.dataMap = new DataMap();
        }
        this.dataMap.put(Objects.requireNonNull(key), data);
        return this;
    }

    @Override
    public TemplateInstance computedData(String key, Function<String, Object> function) {
        this.data = null;
        if (this.dataMap == null) {
            this.dataMap = new DataMap();
        }
        this.dataMap.computed(Objects.requireNonNull(key), Objects.requireNonNull(function));
        return this;
    }

    @Override
    public TemplateInstance setAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public TemplateInstance onRendered(Runnable action) {
        if (this.renderedActions == null) {
            this.renderedActions = new ArrayList<Runnable>();
        }
        this.renderedActions.add(action);
        return this;
    }

    @Override
    public long getTimeout() {
        return this.attributes.isEmpty() ? this.engine().getTimeout() : this.getTimeoutAttributeValue();
    }

    private long getTimeoutAttributeValue() {
        Object t = this.getAttribute("timeout");
        if (t != null) {
            if (t instanceof Long) {
                return (Long)t;
            }
            try {
                return Long.parseLong(t.toString());
            }
            catch (NumberFormatException e) {
                LOG.warnf("Invalid timeout value set for " + this.toString() + ": " + String.valueOf(t), new Object[0]);
            }
        }
        return this.engine().getTimeout();
    }

    protected Object data() {
        if (this.data != null) {
            return this.data;
        }
        if (this.dataMap != null) {
            return this.dataMap;
        }
        return EMPTY_DATA_MAP;
    }

    protected abstract Engine engine();

    public static class DataMap
    implements Mapper {
        private final Map<String, Object> map = new HashMap<String, Object>();
        private Map<String, Function<String, Object>> computations = null;

        void put(String key, Object value) {
            this.map.put(key, value);
        }

        void computed(String key, Function<String, Object> function) {
            if (!this.map.containsKey(key)) {
                if (this.computations == null) {
                    this.computations = new HashMap<String, Function<String, Object>>();
                }
                this.computations.put(key, function);
            }
        }

        @Override
        public Object get(String key) {
            Object val = this.map.get(key);
            if (val == null) {
                Function<String, Object> fun;
                if (key.equals(TemplateInstanceBase.DATA_MAP_KEY)) {
                    return true;
                }
                if (this.computations != null && (fun = this.computations.get(key)) != null) {
                    return fun.apply(key);
                }
            }
            return val;
        }

        @Override
        public boolean appliesTo(String key) {
            return this.map.containsKey(key) || this.computations != null && this.computations.containsKey(key);
        }

        @Override
        public Set<String> mappedKeys() {
            HashSet<String> ret = new HashSet<String>(this.map.keySet());
            if (this.computations != null) {
                ret.addAll(this.computations.keySet());
            }
            return ret;
        }

        public void forEachData(BiConsumer<String, Object> action) {
            this.map.forEach(action);
        }

        public void forEachComputedData(BiConsumer<String, Function<String, Object>> action) {
            if (this.computations != null) {
                this.computations.forEach(action);
            }
        }
    }
}

