/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.AccessorCandidate;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.EvaluatedParams;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Results;
import io.quarkus.qute.ValueAccessor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

final class MethodsCandidate
implements AccessorCandidate {
    private final List<Method> methods;

    public MethodsCandidate(List<Method> methods) {
        this.methods = methods;
    }

    @Override
    public ValueAccessor getAccessor(final EvalContext context) {
        final EvaluatedParams params = EvaluatedParams.evaluate(context);
        return new ValueAccessor(){

            @Override
            public CompletionStage<Object> getValue(Object instance) {
                CompletableFuture<Object> result = new CompletableFuture<Object>();
                params.stage.whenComplete((r, t) -> {
                    if (t != null) {
                        result.completeExceptionally((Throwable)t);
                    } else {
                        for (Method method : MethodsCandidate.this.methods) {
                            try {
                                if (!params.parameterTypesMatch(method.isVarArgs(), method.getParameterTypes())) continue;
                                Class<?>[] parameterTypes = method.getParameterTypes();
                                Object[] args = new Object[method.getParameterCount()];
                                for (int i = 0; i < args.length; ++i) {
                                    if (method.isVarArgs() && i == args.length - 1) {
                                        Class<?> lastParam = parameterTypes[i];
                                        args[i] = params.getVarargsResults(method.getParameterCount(), lastParam.getComponentType());
                                        continue;
                                    }
                                    args[i] = params.getResult(i);
                                }
                                result.complete(method.invoke(instance, args));
                                return;
                            }
                            catch (Exception e) {
                                result.completeExceptionally(e);
                                return;
                            }
                        }
                        result.complete(Results.NotFound.from(context));
                    }
                });
                return result;
            }
        };
    }

    @Override
    public boolean isShared(EvalContext context) {
        if (this.methods.size() == 1) {
            for (Expression param : context.getParams()) {
                if (param.isLiteral()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

