/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.ValueResolvers;
import java.util.concurrent.CompletionStage;

public final class NamedArgument {
    private final String name;
    private volatile Object value;

    public NamedArgument(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public NamedArgument setValue(Object value) {
        this.value = value;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public static final class SetValueResolver
    implements ValueResolver {
        @Override
        public boolean appliesTo(EvalContext context) {
            if (context.getParams().size() != 1) {
                return false;
            }
            String name = context.getName();
            return (name.equals("=") || name.equals("set")) && ValueResolvers.matchClass(context, NamedArgument.class);
        }

        @Override
        public CompletionStage<Object> resolve(EvalContext context) {
            NamedArgument argument = (NamedArgument)context.getBase();
            return context.evaluate(context.getParams().get(0)).thenApply(v -> argument.setValue(v));
        }
    }

    public static final class ParamNamespaceResolver
    implements NamespaceResolver {
        private final String name;
        private final int priority;

        public ParamNamespaceResolver() {
            this("param", -1);
        }

        public ParamNamespaceResolver(String name, int priority) {
            this.name = name;
            this.priority = priority;
        }

        @Override
        public CompletionStage<Object> resolve(EvalContext context) {
            return CompletedStage.of(new NamedArgument(context.getName()));
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public String getNamespace() {
            return this.name;
        }
    }
}

