/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.registry.ValueRegistry;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.smallrye.config.SmallRyeConfig;
import java.net.URI;

public record ListeningAddress(Integer port, String protocol) {
    public static final ValueRegistry.RuntimeKey<Integer> HTTP_PORT = ValueRegistry.RuntimeKey.intKey((String)"quarkus.http.port");
    public static final ValueRegistry.RuntimeKey<Integer> HTTP_TEST_PORT = ValueRegistry.RuntimeKey.intKey((String)"quarkus.http.test-port");
    public static final ValueRegistry.RuntimeKey<Integer> HTTPS_PORT = ValueRegistry.RuntimeKey.intKey((String)"quarkus.http.ssl-port");
    public static final ValueRegistry.RuntimeKey<Integer> HTTPS_TEST_PORT = ValueRegistry.RuntimeKey.intKey((String)"quarkus.http.test-ssl-port");
    public static final ValueRegistry.RuntimeKey<URI> LOCAL_BASE_URI = ValueRegistry.RuntimeKey.key((String)"quarkus.http.local-base-uri");

    public boolean isSsl() {
        return "https".equals(this.protocol);
    }

    public void register(ValueRegistry valueRegistry, SmallRyeConfig config) {
        valueRegistry.register(this.isSsl() ? HTTPS_PORT : HTTP_PORT, (Object)this.port);
        valueRegistry.register(this.isSsl() ? HTTPS_TEST_PORT : HTTP_TEST_PORT, (Object)this.port);
        valueRegistry.register(LOCAL_BASE_URI, (Object)URI.create(TestHTTPResourceManager.testUrl(valueRegistry, config, new String[0])));
    }
}

