/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment;

import io.quarkus.deployment.util.ServiceUtil;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class RESTEasyExtension
implements AnnotationScannerExtension {
    private static final DotName DOTNAME_PROVIDER = DotName.createSimple((String)"jakarta.ws.rs.ext.Provider");
    private static final DotName DOTNAME_ASYNC_RESPONSE_PROVIDER = DotName.createSimple((String)"org.jboss.resteasy.spi.AsyncResponseProvider");
    private final List<DotName> asyncTypes = new ArrayList<DotName>();

    public RESTEasyExtension(IndexView index) {
        this.scanAsyncResponseProvidersFromServices();
        this.scanAsyncResponseProviders(index);
    }

    private void scanAsyncResponseProvidersFromServices() {
        try {
            Class<?> asyncResponseProvider = Class.forName("org.jboss.resteasy.spi.AsyncResponseProvider", false, Thread.currentThread().getContextClassLoader());
            for (String provider : ServiceUtil.classNamesNamedIn((ClassLoader)this.getClass().getClassLoader(), (String)"META-INF/services/jakarta.ws.rs.ext.Providers")) {
                this.scanAsyncResponseProvidersFromClassName(asyncResponseProvider, provider);
            }
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void scanAsyncResponseProvidersFromClassName(Class<?> asyncResponseProviderClass, String name) {
        try {
            Class<?> klass = Class.forName(name, false, Thread.currentThread().getContextClassLoader());
            if (asyncResponseProviderClass.isAssignableFrom(klass)) {
                for (java.lang.reflect.Type type : klass.getGenericInterfaces()) {
                    ParameterizedType pType;
                    if (!(type instanceof ParameterizedType) || !(pType = (ParameterizedType)type).getRawType().equals(asyncResponseProviderClass) || pType.getActualTypeArguments().length != 1) continue;
                    java.lang.reflect.Type asyncType = pType.getActualTypeArguments()[0];
                    String asyncTypeName = asyncType instanceof ParameterizedType ? ((ParameterizedType)asyncType).getRawType().getTypeName() : asyncType.getTypeName();
                    this.asyncTypes.add(DotName.createSimple((String)asyncTypeName));
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void scanAsyncResponseProviders(IndexView index) {
        for (ClassInfo providerClass : index.getAllKnownImplementors(DOTNAME_ASYNC_RESPONSE_PROVIDER)) {
            for (AnnotationInstance annotation : providerClass.declaredAnnotations()) {
                if (!annotation.name().equals((Object)DOTNAME_PROVIDER)) continue;
                for (Type interf : providerClass.interfaceTypes()) {
                    org.jboss.jandex.ParameterizedType pType;
                    if (interf.kind() != Type.Kind.PARAMETERIZED_TYPE || !interf.name().equals((Object)DOTNAME_ASYNC_RESPONSE_PROVIDER) || (pType = interf.asParameterizedType()).arguments().size() != 1) continue;
                    Type asyncType = (Type)pType.arguments().get(0);
                    this.asyncTypes.add(asyncType.name());
                }
            }
        }
    }

    public Type resolveAsyncType(Type type) {
        org.jboss.jandex.ParameterizedType pType;
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE && this.asyncTypes.contains(type.name()) && (pType = type.asParameterizedType()).arguments().size() == 1) {
            return (Type)pType.arguments().get(0);
        }
        return null;
    }
}

