/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.qute.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.qute.Engine;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.resteasy.reactive.qute.runtime.Util;
import io.smallrye.mutiny.Uni;
import jakarta.ws.rs.core.MediaType;
import java.lang.annotation.Annotation;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class TemplateResponseUniHandler
implements ServerRestHandler {
    private volatile Engine engine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ResteasyReactiveRequestContext requestContext) {
        Object result = requestContext.getResult();
        if (!(result instanceof TemplateInstance)) {
            return;
        }
        requestContext.requireCDIRequestScope();
        if (this.engine == null) {
            TemplateResponseUniHandler templateResponseUniHandler = this;
            synchronized (templateResponseUniHandler) {
                if (this.engine == null) {
                    this.engine = (Engine)Arc.container().instance(Engine.class, new Annotation[0]).get();
                }
            }
        }
        requestContext.setResult(this.createUni(requestContext, (TemplateInstance)result, this.engine));
    }

    private Uni<String> createUni(ResteasyReactiveRequestContext requestContext, TemplateInstance result, Engine engine) {
        MediaType mediaType = Util.setSelectedVariant(result, requestContext.getRequest(), requestContext.getHttpHeaders().getAcceptableLanguages());
        requestContext.setResponseContentType(mediaType);
        return Util.toUni(result, engine);
    }
}

