/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.config;

import io.quarkus.restclient.config.RestClientConfig;
import io.quarkus.restclient.config.RestClientLoggingConfig;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@ConfigRoot(name="rest-client", phase=ConfigPhase.RUN_TIME)
public class RestClientsConfig {
    @ConfigItem(name="<<parent>>")
    Map<String, RestClientConfig> preloadedConfigs;
    @Deprecated
    final Map<String, RestClientConfig> configs = new ConcurrentHashMap<String, RestClientConfig>();
    @ConfigItem(defaultValue="false")
    public Optional<Boolean> disableSmartProduces;
    @ConfigItem
    public Optional<String> multipartPostEncoderMode;
    public RestClientLoggingConfig logging;

    public RestClientConfig getClientConfig(String configKey) {
        if (configKey == null) {
            return RestClientConfig.EMPTY;
        }
        return this.configs.computeIfAbsent(configKey, RestClientConfig::load);
    }

    public RestClientConfig getClientConfig(Class<?> clientInterface) {
        return this.configs.computeIfAbsent(clientInterface.getName(), name -> RestClientConfig.load(clientInterface));
    }

    public void putClientConfig(String configKey, RestClientConfig clientConfig) {
        this.configs.put(configKey, clientConfig);
    }

    public void putClientConfig(Class<?> clientInterface, RestClientConfig clientConfig) {
        this.configs.put(clientInterface.getName(), clientConfig);
    }
}

