/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mutiny.deployment;

import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.mutiny.runtime.MutinyInfrastructure;
import java.util.concurrent.ExecutorService;

public class MutinyProcessor {
    @BuildStep
    public FeatureBuildItem registerFeature() {
        return new FeatureBuildItem(Feature.MUTINY);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void initExecutor(ExecutorBuildItem executorBuildItem, MutinyInfrastructure recorder) {
        ExecutorService executor = executorBuildItem.getExecutorProxy();
        recorder.configureMutinyInfrastructure(executor);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void configureDroppedExceptionHandlerAndThreadBlockingChecker(MutinyInfrastructure recorder) {
        recorder.configureDroppedExceptionHandlerAndThreadBlockingChecker();
    }
}

