/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.descriptor.loader.json;

import io.quarkus.platform.descriptor.loader.json.ResourceInputStreamConsumer;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import io.quarkus.platform.descriptor.loader.json.ResourceLoaders;
import io.quarkus.platform.descriptor.loader.json.ResourcePathConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;

public class ClassPathResourceLoader
implements ResourceLoader {
    private final ClassLoader cl;

    public ClassPathResourceLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ClassPathResourceLoader(ClassLoader cl) {
        this.cl = cl;
    }

    @Override
    public <T> T loadResourceAsPath(String name, ResourcePathConsumer<T> consumer) throws IOException {
        URL url = this.cl.getResource(name);
        if (url == null) {
            throw new IOException("Failed to locate " + name + " on the classpath");
        }
        return (T)ResourceLoaders.processAsPath(url, is -> {
            try {
                return consumer.consume((Path)is);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @Override
    public <T> T loadResource(String name, ResourceInputStreamConsumer<T> consumer) throws IOException {
        InputStream stream = this.cl.getResourceAsStream(name);
        if (stream == null) {
            throw new IOException("Failed to locate " + name + " on the classpath");
        }
        return consumer.consume(stream);
    }
}

