/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.extensions;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ExtensionInstallPlan {
    public static final ExtensionInstallPlan EMPTY = new ExtensionInstallPlan(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    private final Set<AppArtifactCoords> platforms;
    private final Set<AppArtifactCoords> managedExtensions;
    private final Set<AppArtifactCoords> independentExtensions;

    private ExtensionInstallPlan(Set<AppArtifactCoords> platforms, Set<AppArtifactCoords> managedExtensions, Set<AppArtifactCoords> independentExtensions) {
        this.platforms = platforms;
        this.managedExtensions = managedExtensions;
        this.independentExtensions = independentExtensions;
    }

    public boolean isNotEmpty() {
        return !this.platforms.isEmpty() || !this.managedExtensions.isEmpty() || !this.independentExtensions.isEmpty();
    }

    public Collection<AppArtifactCoords> toCollection() {
        LinkedHashSet<AppArtifactCoords> result = new LinkedHashSet<AppArtifactCoords>();
        result.addAll(this.getPlatforms());
        result.addAll(this.getManagedExtensions());
        result.addAll(this.getIndependentExtensions());
        return result;
    }

    public Collection<AppArtifactCoords> getPlatforms() {
        return this.platforms;
    }

    public Collection<AppArtifactCoords> getManagedExtensions() {
        return this.managedExtensions;
    }

    public Collection<AppArtifactCoords> getIndependentExtensions() {
        return this.independentExtensions;
    }

    public String toString() {
        return "InstallRequest{platforms=" + this.platforms + ", managedExtensions=" + this.managedExtensions + ", independentExtensions=" + this.independentExtensions + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<AppArtifactCoords> platforms = new LinkedHashSet<AppArtifactCoords>();
        private final Set<AppArtifactCoords> extensionsInPlatforms = new LinkedHashSet<AppArtifactCoords>();
        private final Set<AppArtifactCoords> independentExtensions = new LinkedHashSet<AppArtifactCoords>();

        public ExtensionInstallPlan build() {
            return new ExtensionInstallPlan(this.platforms, this.extensionsInPlatforms, this.independentExtensions);
        }

        public Builder addIndependentExtension(AppArtifactCoords appArtifactCoords) {
            this.independentExtensions.add(appArtifactCoords);
            return this;
        }

        public Builder addManagedExtension(AppArtifactCoords appArtifactCoords) {
            this.extensionsInPlatforms.add(appArtifactCoords);
            return this;
        }

        public Builder addPlatform(AppArtifactCoords appArtifactCoords) {
            this.platforms.add(appArtifactCoords);
            return this;
        }

        public boolean hasExtensionInPlatform() {
            return !this.extensionsInPlatforms.isEmpty();
        }
    }
}

